/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SurveyRequestMessage;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class SignedSurveyRequestMessage
implements XdrElement {
    private Signature requestSignature;
    private SurveyRequestMessage request;

    public Signature getRequestSignature() {
        return this.requestSignature;
    }

    public void setRequestSignature(Signature value) {
        this.requestSignature = value;
    }

    public SurveyRequestMessage getRequest() {
        return this.request;
    }

    public void setRequest(SurveyRequestMessage value) {
        this.request = value;
    }

    public static void encode(XdrDataOutputStream stream, SignedSurveyRequestMessage encodedSignedSurveyRequestMessage) throws IOException {
        Signature.encode(stream, encodedSignedSurveyRequestMessage.requestSignature);
        SurveyRequestMessage.encode(stream, encodedSignedSurveyRequestMessage.request);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SignedSurveyRequestMessage.encode(stream, this);
    }

    public static SignedSurveyRequestMessage decode(XdrDataInputStream stream) throws IOException {
        SignedSurveyRequestMessage decodedSignedSurveyRequestMessage = new SignedSurveyRequestMessage();
        decodedSignedSurveyRequestMessage.requestSignature = Signature.decode(stream);
        decodedSignedSurveyRequestMessage.request = SurveyRequestMessage.decode(stream);
        return decodedSignedSurveyRequestMessage;
    }

    public int hashCode() {
        return Objects.hashCode(this.requestSignature, this.request);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignedSurveyRequestMessage)) {
            return false;
        }
        SignedSurveyRequestMessage other = (SignedSurveyRequestMessage)object;
        return Objects.equal(this.requestSignature, other.requestSignature) && Objects.equal(this.request, other.request);
    }

    public static final class Builder {
        private Signature requestSignature;
        private SurveyRequestMessage request;

        public Builder requestSignature(Signature requestSignature) {
            this.requestSignature = requestSignature;
            return this;
        }

        public Builder request(SurveyRequestMessage request) {
            this.request = request;
            return this;
        }

        public SignedSurveyRequestMessage build() {
            SignedSurveyRequestMessage val = new SignedSurveyRequestMessage();
            val.setRequestSignature(this.requestSignature);
            val.setRequest(this.request);
            return val;
        }
    }
}

