/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCPStatementType implements XdrElement
{
    SCP_ST_PREPARE(0),
    SCP_ST_CONFIRM(1),
    SCP_ST_EXTERNALIZE(2),
    SCP_ST_NOMINATE(3);

    private int mValue;

    private SCPStatementType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static SCPStatementType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SCP_ST_PREPARE;
            }
            case 1: {
                return SCP_ST_CONFIRM;
            }
            case 2: {
                return SCP_ST_EXTERNALIZE;
            }
            case 3: {
                return SCP_ST_NOMINATE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, SCPStatementType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCPStatementType.encode(stream, this);
    }
}

