/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.IPAddrType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class PeerAddress
implements XdrElement {
    private PeerAddressIp ip;
    private Uint32 port;
    private Uint32 numFailures;

    public PeerAddressIp getIp() {
        return this.ip;
    }

    public void setIp(PeerAddressIp value) {
        this.ip = value;
    }

    public Uint32 getPort() {
        return this.port;
    }

    public void setPort(Uint32 value) {
        this.port = value;
    }

    public Uint32 getNumFailures() {
        return this.numFailures;
    }

    public void setNumFailures(Uint32 value) {
        this.numFailures = value;
    }

    public static void encode(XdrDataOutputStream stream, PeerAddress encodedPeerAddress) throws IOException {
        PeerAddressIp.encode(stream, encodedPeerAddress.ip);
        Uint32.encode(stream, encodedPeerAddress.port);
        Uint32.encode(stream, encodedPeerAddress.numFailures);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PeerAddress.encode(stream, this);
    }

    public static PeerAddress decode(XdrDataInputStream stream) throws IOException {
        PeerAddress decodedPeerAddress = new PeerAddress();
        decodedPeerAddress.ip = PeerAddressIp.decode(stream);
        decodedPeerAddress.port = Uint32.decode(stream);
        decodedPeerAddress.numFailures = Uint32.decode(stream);
        return decodedPeerAddress;
    }

    public int hashCode() {
        return Objects.hashCode(this.ip, this.port, this.numFailures);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PeerAddress)) {
            return false;
        }
        PeerAddress other = (PeerAddress)object;
        return Objects.equal(this.ip, other.ip) && Objects.equal(this.port, other.port) && Objects.equal(this.numFailures, other.numFailures);
    }

    public static class PeerAddressIp {
        IPAddrType type;
        private byte[] ipv4;
        private byte[] ipv6;

        public IPAddrType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(IPAddrType value) {
            this.type = value;
        }

        public byte[] getIpv4() {
            return this.ipv4;
        }

        public void setIpv4(byte[] value) {
            this.ipv4 = value;
        }

        public byte[] getIpv6() {
            return this.ipv6;
        }

        public void setIpv6(byte[] value) {
            this.ipv6 = value;
        }

        public static void encode(XdrDataOutputStream stream, PeerAddressIp encodedPeerAddressIp) throws IOException {
            stream.writeInt(encodedPeerAddressIp.getDiscriminant().getValue());
            switch (encodedPeerAddressIp.getDiscriminant()) {
                case IPv4: {
                    int ipv4size = encodedPeerAddressIp.ipv4.length;
                    stream.write(encodedPeerAddressIp.getIpv4(), 0, ipv4size);
                    break;
                }
                case IPv6: {
                    int ipv6size = encodedPeerAddressIp.ipv6.length;
                    stream.write(encodedPeerAddressIp.getIpv6(), 0, ipv6size);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            PeerAddressIp.encode(stream, this);
        }

        public static PeerAddressIp decode(XdrDataInputStream stream) throws IOException {
            PeerAddressIp decodedPeerAddressIp = new PeerAddressIp();
            IPAddrType discriminant = IPAddrType.decode(stream);
            decodedPeerAddressIp.setDiscriminant(discriminant);
            switch (decodedPeerAddressIp.getDiscriminant()) {
                case IPv4: {
                    int ipv4size = 4;
                    decodedPeerAddressIp.ipv4 = new byte[ipv4size];
                    stream.read(decodedPeerAddressIp.ipv4, 0, ipv4size);
                    break;
                }
                case IPv6: {
                    int ipv6size = 16;
                    decodedPeerAddressIp.ipv6 = new byte[ipv6size];
                    stream.read(decodedPeerAddressIp.ipv6, 0, ipv6size);
                }
            }
            return decodedPeerAddressIp;
        }

        public int hashCode() {
            return Objects.hashCode(Arrays.hashCode(this.ipv4), Arrays.hashCode(this.ipv6), this.type);
        }

        public boolean equals(Object object) {
            if (!(object instanceof PeerAddressIp)) {
                return false;
            }
            PeerAddressIp other = (PeerAddressIp)object;
            return Arrays.equals(this.ipv4, other.ipv4) && Arrays.equals(this.ipv6, other.ipv6) && Objects.equal(this.type, other.type);
        }

        public static final class Builder {
            private IPAddrType discriminant;
            private byte[] ipv4;
            private byte[] ipv6;

            public Builder discriminant(IPAddrType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder ipv4(byte[] ipv4) {
                this.ipv4 = ipv4;
                return this;
            }

            public Builder ipv6(byte[] ipv6) {
                this.ipv6 = ipv6;
                return this;
            }

            public PeerAddressIp build() {
                PeerAddressIp val = new PeerAddressIp();
                val.setDiscriminant(this.discriminant);
                val.setIpv4(this.ipv4);
                val.setIpv6(this.ipv6);
                return val;
            }
        }
    }

    public static final class Builder {
        private PeerAddressIp ip;
        private Uint32 port;
        private Uint32 numFailures;

        public Builder ip(PeerAddressIp ip) {
            this.ip = ip;
            return this;
        }

        public Builder port(Uint32 port) {
            this.port = port;
            return this;
        }

        public Builder numFailures(Uint32 numFailures) {
            this.numFailures = numFailures;
            return this;
        }

        public PeerAddress build() {
            PeerAddress val = new PeerAddress();
            val.setIp(this.ip);
            val.setPort(this.port);
            val.setNumFailures(this.numFailures);
            return val;
        }
    }
}

