/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum OperationResultCode implements XdrElement
{
    opINNER(0),
    opBAD_AUTH(-1),
    opNO_ACCOUNT(-2),
    opNOT_SUPPORTED(-3),
    opTOO_MANY_SUBENTRIES(-4),
    opEXCEEDED_WORK_LIMIT(-5),
    opTOO_MANY_SPONSORING(-6);

    private int mValue;

    private OperationResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static OperationResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return opINNER;
            }
            case -1: {
                return opBAD_AUTH;
            }
            case -2: {
                return opNO_ACCOUNT;
            }
            case -3: {
                return opNOT_SUPPORTED;
            }
            case -4: {
                return opTOO_MANY_SUBENTRIES;
            }
            case -5: {
                return opEXCEEDED_WORK_LIMIT;
            }
            case -6: {
                return opTOO_MANY_SPONSORING;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, OperationResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        OperationResultCode.encode(stream, this);
    }
}

