/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class OperationID
implements XdrElement {
    EnvelopeType type;
    private OperationIDId id;
    private OperationIDRevokeId revokeId;

    public EnvelopeType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(EnvelopeType value) {
        this.type = value;
    }

    public OperationIDId getId() {
        return this.id;
    }

    public void setId(OperationIDId value) {
        this.id = value;
    }

    public OperationIDRevokeId getRevokeId() {
        return this.revokeId;
    }

    public void setRevokeId(OperationIDRevokeId value) {
        this.revokeId = value;
    }

    public static void encode(XdrDataOutputStream stream, OperationID encodedOperationID) throws IOException {
        stream.writeInt(encodedOperationID.getDiscriminant().getValue());
        switch (encodedOperationID.getDiscriminant()) {
            case ENVELOPE_TYPE_OP_ID: {
                OperationIDId.encode(stream, encodedOperationID.id);
                break;
            }
            case ENVELOPE_TYPE_POOL_REVOKE_OP_ID: {
                OperationIDRevokeId.encode(stream, encodedOperationID.revokeId);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        OperationID.encode(stream, this);
    }

    public static OperationID decode(XdrDataInputStream stream) throws IOException {
        OperationID decodedOperationID = new OperationID();
        EnvelopeType discriminant = EnvelopeType.decode(stream);
        decodedOperationID.setDiscriminant(discriminant);
        switch (decodedOperationID.getDiscriminant()) {
            case ENVELOPE_TYPE_OP_ID: {
                decodedOperationID.id = OperationIDId.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_POOL_REVOKE_OP_ID: {
                decodedOperationID.revokeId = OperationIDRevokeId.decode(stream);
            }
        }
        return decodedOperationID;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.revokeId, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OperationID)) {
            return false;
        }
        OperationID other = (OperationID)object;
        return Objects.equal(this.id, other.id) && Objects.equal(this.revokeId, other.revokeId) && Objects.equal(this.type, other.type);
    }

    public static class OperationIDRevokeId {
        private AccountID sourceAccount;
        private SequenceNumber seqNum;
        private Uint32 opNum;
        private PoolID liquidityPoolID;
        private Asset asset;

        public AccountID getSourceAccount() {
            return this.sourceAccount;
        }

        public void setSourceAccount(AccountID value) {
            this.sourceAccount = value;
        }

        public SequenceNumber getSeqNum() {
            return this.seqNum;
        }

        public void setSeqNum(SequenceNumber value) {
            this.seqNum = value;
        }

        public Uint32 getOpNum() {
            return this.opNum;
        }

        public void setOpNum(Uint32 value) {
            this.opNum = value;
        }

        public PoolID getLiquidityPoolID() {
            return this.liquidityPoolID;
        }

        public void setLiquidityPoolID(PoolID value) {
            this.liquidityPoolID = value;
        }

        public Asset getAsset() {
            return this.asset;
        }

        public void setAsset(Asset value) {
            this.asset = value;
        }

        public static void encode(XdrDataOutputStream stream, OperationIDRevokeId encodedOperationIDRevokeId) throws IOException {
            AccountID.encode(stream, encodedOperationIDRevokeId.sourceAccount);
            SequenceNumber.encode(stream, encodedOperationIDRevokeId.seqNum);
            Uint32.encode(stream, encodedOperationIDRevokeId.opNum);
            PoolID.encode(stream, encodedOperationIDRevokeId.liquidityPoolID);
            Asset.encode(stream, encodedOperationIDRevokeId.asset);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            OperationIDRevokeId.encode(stream, this);
        }

        public static OperationIDRevokeId decode(XdrDataInputStream stream) throws IOException {
            OperationIDRevokeId decodedOperationIDRevokeId = new OperationIDRevokeId();
            decodedOperationIDRevokeId.sourceAccount = AccountID.decode(stream);
            decodedOperationIDRevokeId.seqNum = SequenceNumber.decode(stream);
            decodedOperationIDRevokeId.opNum = Uint32.decode(stream);
            decodedOperationIDRevokeId.liquidityPoolID = PoolID.decode(stream);
            decodedOperationIDRevokeId.asset = Asset.decode(stream);
            return decodedOperationIDRevokeId;
        }

        public int hashCode() {
            return Objects.hashCode(this.sourceAccount, this.seqNum, this.opNum, this.liquidityPoolID, this.asset);
        }

        public boolean equals(Object object) {
            if (!(object instanceof OperationIDRevokeId)) {
                return false;
            }
            OperationIDRevokeId other = (OperationIDRevokeId)object;
            return Objects.equal(this.sourceAccount, other.sourceAccount) && Objects.equal(this.seqNum, other.seqNum) && Objects.equal(this.opNum, other.opNum) && Objects.equal(this.liquidityPoolID, other.liquidityPoolID) && Objects.equal(this.asset, other.asset);
        }

        public static final class Builder {
            private AccountID sourceAccount;
            private SequenceNumber seqNum;
            private Uint32 opNum;
            private PoolID liquidityPoolID;
            private Asset asset;

            public Builder sourceAccount(AccountID sourceAccount) {
                this.sourceAccount = sourceAccount;
                return this;
            }

            public Builder seqNum(SequenceNumber seqNum) {
                this.seqNum = seqNum;
                return this;
            }

            public Builder opNum(Uint32 opNum) {
                this.opNum = opNum;
                return this;
            }

            public Builder liquidityPoolID(PoolID liquidityPoolID) {
                this.liquidityPoolID = liquidityPoolID;
                return this;
            }

            public Builder asset(Asset asset) {
                this.asset = asset;
                return this;
            }

            public OperationIDRevokeId build() {
                OperationIDRevokeId val = new OperationIDRevokeId();
                val.setSourceAccount(this.sourceAccount);
                val.setSeqNum(this.seqNum);
                val.setOpNum(this.opNum);
                val.setLiquidityPoolID(this.liquidityPoolID);
                val.setAsset(this.asset);
                return val;
            }
        }
    }

    public static class OperationIDId {
        private AccountID sourceAccount;
        private SequenceNumber seqNum;
        private Uint32 opNum;

        public AccountID getSourceAccount() {
            return this.sourceAccount;
        }

        public void setSourceAccount(AccountID value) {
            this.sourceAccount = value;
        }

        public SequenceNumber getSeqNum() {
            return this.seqNum;
        }

        public void setSeqNum(SequenceNumber value) {
            this.seqNum = value;
        }

        public Uint32 getOpNum() {
            return this.opNum;
        }

        public void setOpNum(Uint32 value) {
            this.opNum = value;
        }

        public static void encode(XdrDataOutputStream stream, OperationIDId encodedOperationIDId) throws IOException {
            AccountID.encode(stream, encodedOperationIDId.sourceAccount);
            SequenceNumber.encode(stream, encodedOperationIDId.seqNum);
            Uint32.encode(stream, encodedOperationIDId.opNum);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            OperationIDId.encode(stream, this);
        }

        public static OperationIDId decode(XdrDataInputStream stream) throws IOException {
            OperationIDId decodedOperationIDId = new OperationIDId();
            decodedOperationIDId.sourceAccount = AccountID.decode(stream);
            decodedOperationIDId.seqNum = SequenceNumber.decode(stream);
            decodedOperationIDId.opNum = Uint32.decode(stream);
            return decodedOperationIDId;
        }

        public int hashCode() {
            return Objects.hashCode(this.sourceAccount, this.seqNum, this.opNum);
        }

        public boolean equals(Object object) {
            if (!(object instanceof OperationIDId)) {
                return false;
            }
            OperationIDId other = (OperationIDId)object;
            return Objects.equal(this.sourceAccount, other.sourceAccount) && Objects.equal(this.seqNum, other.seqNum) && Objects.equal(this.opNum, other.opNum);
        }

        public static final class Builder {
            private AccountID sourceAccount;
            private SequenceNumber seqNum;
            private Uint32 opNum;

            public Builder sourceAccount(AccountID sourceAccount) {
                this.sourceAccount = sourceAccount;
                return this;
            }

            public Builder seqNum(SequenceNumber seqNum) {
                this.seqNum = seqNum;
                return this;
            }

            public Builder opNum(Uint32 opNum) {
                this.opNum = opNum;
                return this;
            }

            public OperationIDId build() {
                OperationIDId val = new OperationIDId();
                val.setSourceAccount(this.sourceAccount);
                val.setSeqNum(this.seqNum);
                val.setOpNum(this.opNum);
                return val;
            }
        }
    }

    public static final class Builder {
        private EnvelopeType discriminant;
        private OperationIDId id;
        private OperationIDRevokeId revokeId;

        public Builder discriminant(EnvelopeType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder id(OperationIDId id) {
            this.id = id;
            return this;
        }

        public Builder revokeId(OperationIDRevokeId revokeId) {
            this.revokeId = revokeId;
            return this;
        }

        public OperationID build() {
            OperationID val = new OperationID();
            val.setDiscriminant(this.discriminant);
            val.setId(this.id);
            val.setRevokeId(this.revokeId);
            return val;
        }
    }
}

