/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum MemoType implements XdrElement
{
    MEMO_NONE(0),
    MEMO_TEXT(1),
    MEMO_ID(2),
    MEMO_HASH(3),
    MEMO_RETURN(4);

    private int mValue;

    private MemoType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static MemoType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return MEMO_NONE;
            }
            case 1: {
                return MEMO_TEXT;
            }
            case 2: {
                return MEMO_ID;
            }
            case 3: {
                return MEMO_HASH;
            }
            case 4: {
                return MEMO_RETURN;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, MemoType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        MemoType.encode(stream, this);
    }
}

