/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ManageDataResultCode implements XdrElement
{
    MANAGE_DATA_SUCCESS(0),
    MANAGE_DATA_NOT_SUPPORTED_YET(-1),
    MANAGE_DATA_NAME_NOT_FOUND(-2),
    MANAGE_DATA_LOW_RESERVE(-3),
    MANAGE_DATA_INVALID_NAME(-4);

    private int mValue;

    private ManageDataResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static ManageDataResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return MANAGE_DATA_SUCCESS;
            }
            case -1: {
                return MANAGE_DATA_NOT_SUPPORTED_YET;
            }
            case -2: {
                return MANAGE_DATA_NAME_NOT_FOUND;
            }
            case -3: {
                return MANAGE_DATA_LOW_RESERVE;
            }
            case -4: {
                return MANAGE_DATA_INVALID_NAME;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, ManageDataResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ManageDataResultCode.encode(stream, this);
    }
}

