/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.LedgerUpgradeType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LedgerUpgrade
implements XdrElement {
    LedgerUpgradeType type;
    private Uint32 newLedgerVersion;
    private Uint32 newBaseFee;
    private Uint32 newMaxTxSetSize;
    private Uint32 newBaseReserve;
    private Uint32 newFlags;

    public LedgerUpgradeType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(LedgerUpgradeType value) {
        this.type = value;
    }

    public Uint32 getNewLedgerVersion() {
        return this.newLedgerVersion;
    }

    public void setNewLedgerVersion(Uint32 value) {
        this.newLedgerVersion = value;
    }

    public Uint32 getNewBaseFee() {
        return this.newBaseFee;
    }

    public void setNewBaseFee(Uint32 value) {
        this.newBaseFee = value;
    }

    public Uint32 getNewMaxTxSetSize() {
        return this.newMaxTxSetSize;
    }

    public void setNewMaxTxSetSize(Uint32 value) {
        this.newMaxTxSetSize = value;
    }

    public Uint32 getNewBaseReserve() {
        return this.newBaseReserve;
    }

    public void setNewBaseReserve(Uint32 value) {
        this.newBaseReserve = value;
    }

    public Uint32 getNewFlags() {
        return this.newFlags;
    }

    public void setNewFlags(Uint32 value) {
        this.newFlags = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerUpgrade encodedLedgerUpgrade) throws IOException {
        stream.writeInt(encodedLedgerUpgrade.getDiscriminant().getValue());
        switch (encodedLedgerUpgrade.getDiscriminant()) {
            case LEDGER_UPGRADE_VERSION: {
                Uint32.encode(stream, encodedLedgerUpgrade.newLedgerVersion);
                break;
            }
            case LEDGER_UPGRADE_BASE_FEE: {
                Uint32.encode(stream, encodedLedgerUpgrade.newBaseFee);
                break;
            }
            case LEDGER_UPGRADE_MAX_TX_SET_SIZE: {
                Uint32.encode(stream, encodedLedgerUpgrade.newMaxTxSetSize);
                break;
            }
            case LEDGER_UPGRADE_BASE_RESERVE: {
                Uint32.encode(stream, encodedLedgerUpgrade.newBaseReserve);
                break;
            }
            case LEDGER_UPGRADE_FLAGS: {
                Uint32.encode(stream, encodedLedgerUpgrade.newFlags);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerUpgrade.encode(stream, this);
    }

    public static LedgerUpgrade decode(XdrDataInputStream stream) throws IOException {
        LedgerUpgrade decodedLedgerUpgrade = new LedgerUpgrade();
        LedgerUpgradeType discriminant = LedgerUpgradeType.decode(stream);
        decodedLedgerUpgrade.setDiscriminant(discriminant);
        switch (decodedLedgerUpgrade.getDiscriminant()) {
            case LEDGER_UPGRADE_VERSION: {
                decodedLedgerUpgrade.newLedgerVersion = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_BASE_FEE: {
                decodedLedgerUpgrade.newBaseFee = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_MAX_TX_SET_SIZE: {
                decodedLedgerUpgrade.newMaxTxSetSize = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_BASE_RESERVE: {
                decodedLedgerUpgrade.newBaseReserve = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_FLAGS: {
                decodedLedgerUpgrade.newFlags = Uint32.decode(stream);
            }
        }
        return decodedLedgerUpgrade;
    }

    public int hashCode() {
        return Objects.hashCode(this.newLedgerVersion, this.newBaseFee, this.newMaxTxSetSize, this.newBaseReserve, this.newFlags, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerUpgrade)) {
            return false;
        }
        LedgerUpgrade other = (LedgerUpgrade)object;
        return Objects.equal(this.newLedgerVersion, other.newLedgerVersion) && Objects.equal(this.newBaseFee, other.newBaseFee) && Objects.equal(this.newMaxTxSetSize, other.newMaxTxSetSize) && Objects.equal(this.newBaseReserve, other.newBaseReserve) && Objects.equal(this.newFlags, other.newFlags) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private LedgerUpgradeType discriminant;
        private Uint32 newLedgerVersion;
        private Uint32 newBaseFee;
        private Uint32 newMaxTxSetSize;
        private Uint32 newBaseReserve;
        private Uint32 newFlags;

        public Builder discriminant(LedgerUpgradeType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder newLedgerVersion(Uint32 newLedgerVersion) {
            this.newLedgerVersion = newLedgerVersion;
            return this;
        }

        public Builder newBaseFee(Uint32 newBaseFee) {
            this.newBaseFee = newBaseFee;
            return this;
        }

        public Builder newMaxTxSetSize(Uint32 newMaxTxSetSize) {
            this.newMaxTxSetSize = newMaxTxSetSize;
            return this;
        }

        public Builder newBaseReserve(Uint32 newBaseReserve) {
            this.newBaseReserve = newBaseReserve;
            return this;
        }

        public Builder newFlags(Uint32 newFlags) {
            this.newFlags = newFlags;
            return this;
        }

        public LedgerUpgrade build() {
            LedgerUpgrade val = new LedgerUpgrade();
            val.setDiscriminant(this.discriminant);
            val.setNewLedgerVersion(this.newLedgerVersion);
            val.setNewBaseFee(this.newBaseFee);
            val.setNewMaxTxSetSize(this.newMaxTxSetSize);
            val.setNewBaseReserve(this.newBaseReserve);
            val.setNewFlags(this.newFlags);
            return val;
        }
    }
}

