/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LedgerCloseValueSignature
implements XdrElement {
    private NodeID nodeID;
    private Signature signature;

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(NodeID value) {
        this.nodeID = value;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature value) {
        this.signature = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerCloseValueSignature encodedLedgerCloseValueSignature) throws IOException {
        NodeID.encode(stream, encodedLedgerCloseValueSignature.nodeID);
        Signature.encode(stream, encodedLedgerCloseValueSignature.signature);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerCloseValueSignature.encode(stream, this);
    }

    public static LedgerCloseValueSignature decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseValueSignature decodedLedgerCloseValueSignature = new LedgerCloseValueSignature();
        decodedLedgerCloseValueSignature.nodeID = NodeID.decode(stream);
        decodedLedgerCloseValueSignature.signature = Signature.decode(stream);
        return decodedLedgerCloseValueSignature;
    }

    public int hashCode() {
        return Objects.hashCode(this.nodeID, this.signature);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerCloseValueSignature)) {
            return false;
        }
        LedgerCloseValueSignature other = (LedgerCloseValueSignature)object;
        return Objects.equal(this.nodeID, other.nodeID) && Objects.equal(this.signature, other.signature);
    }

    public static final class Builder {
        private NodeID nodeID;
        private Signature signature;

        public Builder nodeID(NodeID nodeID) {
            this.nodeID = nodeID;
            return this;
        }

        public Builder signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public LedgerCloseValueSignature build() {
            LedgerCloseValueSignature val = new LedgerCloseValueSignature();
            val.setNodeID(this.nodeID);
            val.setSignature(this.signature);
            return val;
        }
    }
}

