/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.DataValue;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class DataEntry
implements XdrElement {
    private AccountID accountID;
    private String64 dataName;
    private DataValue dataValue;
    private DataEntryExt ext;

    public AccountID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(AccountID value) {
        this.accountID = value;
    }

    public String64 getDataName() {
        return this.dataName;
    }

    public void setDataName(String64 value) {
        this.dataName = value;
    }

    public DataValue getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(DataValue value) {
        this.dataValue = value;
    }

    public DataEntryExt getExt() {
        return this.ext;
    }

    public void setExt(DataEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, DataEntry encodedDataEntry) throws IOException {
        AccountID.encode(stream, encodedDataEntry.accountID);
        String64.encode(stream, encodedDataEntry.dataName);
        DataValue.encode(stream, encodedDataEntry.dataValue);
        DataEntryExt.encode(stream, encodedDataEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        DataEntry.encode(stream, this);
    }

    public static DataEntry decode(XdrDataInputStream stream) throws IOException {
        DataEntry decodedDataEntry = new DataEntry();
        decodedDataEntry.accountID = AccountID.decode(stream);
        decodedDataEntry.dataName = String64.decode(stream);
        decodedDataEntry.dataValue = DataValue.decode(stream);
        decodedDataEntry.ext = DataEntryExt.decode(stream);
        return decodedDataEntry;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountID, this.dataName, this.dataValue, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataEntry)) {
            return false;
        }
        DataEntry other = (DataEntry)object;
        return Objects.equal(this.accountID, other.accountID) && Objects.equal(this.dataName, other.dataName) && Objects.equal(this.dataValue, other.dataValue) && Objects.equal(this.ext, other.ext);
    }

    public static class DataEntryExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, DataEntryExt encodedDataEntryExt) throws IOException {
            stream.writeInt(encodedDataEntryExt.getDiscriminant());
            switch (encodedDataEntryExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            DataEntryExt.encode(stream, this);
        }

        public static DataEntryExt decode(XdrDataInputStream stream) throws IOException {
            DataEntryExt decodedDataEntryExt = new DataEntryExt();
            Integer discriminant = stream.readInt();
            decodedDataEntryExt.setDiscriminant(discriminant);
            switch (decodedDataEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedDataEntryExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof DataEntryExt)) {
                return false;
            }
            DataEntryExt other = (DataEntryExt)object;
            return Objects.equal(this.v, other.v);
        }

        public static final class Builder {
            private Integer discriminant;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public DataEntryExt build() {
                DataEntryExt val = new DataEntryExt();
                val.setDiscriminant(this.discriminant);
                return val;
            }
        }
    }

    public static final class Builder {
        private AccountID accountID;
        private String64 dataName;
        private DataValue dataValue;
        private DataEntryExt ext;

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder dataName(String64 dataName) {
            this.dataName = dataName;
            return this;
        }

        public Builder dataValue(DataValue dataValue) {
            this.dataValue = dataValue;
            return this;
        }

        public Builder ext(DataEntryExt ext) {
            this.ext = ext;
            return this;
        }

        public DataEntry build() {
            DataEntry val = new DataEntry();
            val.setAccountID(this.accountID);
            val.setDataName(this.dataName);
            val.setDataValue(this.dataValue);
            val.setExt(this.ext);
            return val;
        }
    }
}

