/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum CryptoKeyType implements XdrElement
{
    KEY_TYPE_ED25519(0),
    KEY_TYPE_PRE_AUTH_TX(1),
    KEY_TYPE_HASH_X(2),
    KEY_TYPE_MUXED_ED25519(256);

    private int mValue;

    private CryptoKeyType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static CryptoKeyType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return KEY_TYPE_ED25519;
            }
            case 1: {
                return KEY_TYPE_PRE_AUTH_TX;
            }
            case 2: {
                return KEY_TYPE_HASH_X;
            }
            case 256: {
                return KEY_TYPE_MUXED_ED25519;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, CryptoKeyType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        CryptoKeyType.encode(stream, this);
    }
}

