/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Price;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class CreatePassiveSellOfferOp
implements XdrElement {
    private Asset selling;
    private Asset buying;
    private Int64 amount;
    private Price price;

    public Asset getSelling() {
        return this.selling;
    }

    public void setSelling(Asset value) {
        this.selling = value;
    }

    public Asset getBuying() {
        return this.buying;
    }

    public void setBuying(Asset value) {
        this.buying = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price value) {
        this.price = value;
    }

    public static void encode(XdrDataOutputStream stream, CreatePassiveSellOfferOp encodedCreatePassiveSellOfferOp) throws IOException {
        Asset.encode(stream, encodedCreatePassiveSellOfferOp.selling);
        Asset.encode(stream, encodedCreatePassiveSellOfferOp.buying);
        Int64.encode(stream, encodedCreatePassiveSellOfferOp.amount);
        Price.encode(stream, encodedCreatePassiveSellOfferOp.price);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        CreatePassiveSellOfferOp.encode(stream, this);
    }

    public static CreatePassiveSellOfferOp decode(XdrDataInputStream stream) throws IOException {
        CreatePassiveSellOfferOp decodedCreatePassiveSellOfferOp = new CreatePassiveSellOfferOp();
        decodedCreatePassiveSellOfferOp.selling = Asset.decode(stream);
        decodedCreatePassiveSellOfferOp.buying = Asset.decode(stream);
        decodedCreatePassiveSellOfferOp.amount = Int64.decode(stream);
        decodedCreatePassiveSellOfferOp.price = Price.decode(stream);
        return decodedCreatePassiveSellOfferOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.selling, this.buying, this.amount, this.price);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CreatePassiveSellOfferOp)) {
            return false;
        }
        CreatePassiveSellOfferOp other = (CreatePassiveSellOfferOp)object;
        return Objects.equal(this.selling, other.selling) && Objects.equal(this.buying, other.buying) && Objects.equal(this.amount, other.amount) && Objects.equal(this.price, other.price);
    }

    public static final class Builder {
        private Asset selling;
        private Asset buying;
        private Int64 amount;
        private Price price;

        public Builder selling(Asset selling) {
            this.selling = selling;
            return this;
        }

        public Builder buying(Asset buying) {
            this.buying = buying;
            return this;
        }

        public Builder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        public Builder price(Price price) {
            this.price = price;
            return this;
        }

        public CreatePassiveSellOfferOp build() {
            CreatePassiveSellOfferOp val = new CreatePassiveSellOfferOp();
            val.setSelling(this.selling);
            val.setBuying(this.buying);
            val.setAmount(this.amount);
            val.setPrice(this.price);
            return val;
        }
    }
}

