/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.ClaimableBalanceIDType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class ClaimableBalanceID
implements XdrElement {
    ClaimableBalanceIDType type;
    private Hash v0;
    private Hash fromPoolRevoke;

    public ClaimableBalanceIDType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(ClaimableBalanceIDType value) {
        this.type = value;
    }

    public Hash getV0() {
        return this.v0;
    }

    public void setV0(Hash value) {
        this.v0 = value;
    }

    public Hash getFromPoolRevoke() {
        return this.fromPoolRevoke;
    }

    public void setFromPoolRevoke(Hash value) {
        this.fromPoolRevoke = value;
    }

    public static void encode(XdrDataOutputStream stream, ClaimableBalanceID encodedClaimableBalanceID) throws IOException {
        stream.writeInt(encodedClaimableBalanceID.getDiscriminant().getValue());
        switch (encodedClaimableBalanceID.getDiscriminant()) {
            case CLAIMABLE_BALANCE_ID_TYPE_V0: {
                Hash.encode(stream, encodedClaimableBalanceID.v0);
                break;
            }
            case CLAIMABLE_BALANCE_ID_TYPE_FROM_POOL_REVOKE: {
                Hash.encode(stream, encodedClaimableBalanceID.fromPoolRevoke);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimableBalanceID.encode(stream, this);
    }

    public static ClaimableBalanceID decode(XdrDataInputStream stream) throws IOException {
        ClaimableBalanceID decodedClaimableBalanceID = new ClaimableBalanceID();
        ClaimableBalanceIDType discriminant = ClaimableBalanceIDType.decode(stream);
        decodedClaimableBalanceID.setDiscriminant(discriminant);
        switch (decodedClaimableBalanceID.getDiscriminant()) {
            case CLAIMABLE_BALANCE_ID_TYPE_V0: {
                decodedClaimableBalanceID.v0 = Hash.decode(stream);
                break;
            }
            case CLAIMABLE_BALANCE_ID_TYPE_FROM_POOL_REVOKE: {
                decodedClaimableBalanceID.fromPoolRevoke = Hash.decode(stream);
            }
        }
        return decodedClaimableBalanceID;
    }

    public int hashCode() {
        return Objects.hashCode(this.v0, this.fromPoolRevoke, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClaimableBalanceID)) {
            return false;
        }
        ClaimableBalanceID other = (ClaimableBalanceID)object;
        return Objects.equal(this.v0, other.v0) && Objects.equal(this.fromPoolRevoke, other.fromPoolRevoke) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private ClaimableBalanceIDType discriminant;
        private Hash v0;
        private Hash fromPoolRevoke;

        public Builder discriminant(ClaimableBalanceIDType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0(Hash v0) {
            this.v0 = v0;
            return this;
        }

        public Builder fromPoolRevoke(Hash fromPoolRevoke) {
            this.fromPoolRevoke = fromPoolRevoke;
            return this;
        }

        public ClaimableBalanceID build() {
            ClaimableBalanceID val = new ClaimableBalanceID();
            val.setDiscriminant(this.discriminant);
            val.setV0(this.v0);
            val.setFromPoolRevoke(this.fromPoolRevoke);
            return val;
        }
    }
}

