/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.ClaimPredicateType;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class ClaimPredicate
implements XdrElement {
    ClaimPredicateType type;
    private ClaimPredicate[] andPredicates;
    private ClaimPredicate[] orPredicates;
    private ClaimPredicate notPredicate;
    private Int64 absBefore;
    private Int64 relBefore;

    public ClaimPredicateType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(ClaimPredicateType value) {
        this.type = value;
    }

    public ClaimPredicate[] getAndPredicates() {
        return this.andPredicates;
    }

    public void setAndPredicates(ClaimPredicate[] value) {
        this.andPredicates = value;
    }

    public ClaimPredicate[] getOrPredicates() {
        return this.orPredicates;
    }

    public void setOrPredicates(ClaimPredicate[] value) {
        this.orPredicates = value;
    }

    public ClaimPredicate getNotPredicate() {
        return this.notPredicate;
    }

    public void setNotPredicate(ClaimPredicate value) {
        this.notPredicate = value;
    }

    public Int64 getAbsBefore() {
        return this.absBefore;
    }

    public void setAbsBefore(Int64 value) {
        this.absBefore = value;
    }

    public Int64 getRelBefore() {
        return this.relBefore;
    }

    public void setRelBefore(Int64 value) {
        this.relBefore = value;
    }

    public static void encode(XdrDataOutputStream stream, ClaimPredicate encodedClaimPredicate) throws IOException {
        stream.writeInt(encodedClaimPredicate.getDiscriminant().getValue());
        switch (encodedClaimPredicate.getDiscriminant()) {
            case CLAIM_PREDICATE_UNCONDITIONAL: {
                break;
            }
            case CLAIM_PREDICATE_AND: {
                int andPredicatessize = encodedClaimPredicate.getAndPredicates().length;
                stream.writeInt(andPredicatessize);
                for (int i = 0; i < andPredicatessize; ++i) {
                    ClaimPredicate.encode(stream, encodedClaimPredicate.andPredicates[i]);
                }
                break;
            }
            case CLAIM_PREDICATE_OR: {
                int orPredicatessize = encodedClaimPredicate.getOrPredicates().length;
                stream.writeInt(orPredicatessize);
                for (int i = 0; i < orPredicatessize; ++i) {
                    ClaimPredicate.encode(stream, encodedClaimPredicate.orPredicates[i]);
                }
                break;
            }
            case CLAIM_PREDICATE_NOT: {
                if (encodedClaimPredicate.notPredicate != null) {
                    stream.writeInt(1);
                    ClaimPredicate.encode(stream, encodedClaimPredicate.notPredicate);
                    break;
                }
                stream.writeInt(0);
                break;
            }
            case CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME: {
                Int64.encode(stream, encodedClaimPredicate.absBefore);
                break;
            }
            case CLAIM_PREDICATE_BEFORE_RELATIVE_TIME: {
                Int64.encode(stream, encodedClaimPredicate.relBefore);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimPredicate.encode(stream, this);
    }

    public static ClaimPredicate decode(XdrDataInputStream stream) throws IOException {
        ClaimPredicate decodedClaimPredicate = new ClaimPredicate();
        ClaimPredicateType discriminant = ClaimPredicateType.decode(stream);
        decodedClaimPredicate.setDiscriminant(discriminant);
        switch (decodedClaimPredicate.getDiscriminant()) {
            case CLAIM_PREDICATE_UNCONDITIONAL: {
                break;
            }
            case CLAIM_PREDICATE_AND: {
                int andPredicatessize = stream.readInt();
                decodedClaimPredicate.andPredicates = new ClaimPredicate[andPredicatessize];
                for (int i = 0; i < andPredicatessize; ++i) {
                    decodedClaimPredicate.andPredicates[i] = ClaimPredicate.decode(stream);
                }
                break;
            }
            case CLAIM_PREDICATE_OR: {
                int orPredicatessize = stream.readInt();
                decodedClaimPredicate.orPredicates = new ClaimPredicate[orPredicatessize];
                for (int i = 0; i < orPredicatessize; ++i) {
                    decodedClaimPredicate.orPredicates[i] = ClaimPredicate.decode(stream);
                }
                break;
            }
            case CLAIM_PREDICATE_NOT: {
                int notPredicatePresent = stream.readInt();
                if (notPredicatePresent == 0) break;
                decodedClaimPredicate.notPredicate = ClaimPredicate.decode(stream);
                break;
            }
            case CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME: {
                decodedClaimPredicate.absBefore = Int64.decode(stream);
                break;
            }
            case CLAIM_PREDICATE_BEFORE_RELATIVE_TIME: {
                decodedClaimPredicate.relBefore = Int64.decode(stream);
            }
        }
        return decodedClaimPredicate;
    }

    public int hashCode() {
        return Objects.hashCode(Arrays.hashCode(this.andPredicates), Arrays.hashCode(this.orPredicates), this.notPredicate, this.absBefore, this.relBefore, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClaimPredicate)) {
            return false;
        }
        ClaimPredicate other = (ClaimPredicate)object;
        return Arrays.equals(this.andPredicates, other.andPredicates) && Arrays.equals(this.orPredicates, other.orPredicates) && Objects.equal(this.notPredicate, other.notPredicate) && Objects.equal(this.absBefore, other.absBefore) && Objects.equal(this.relBefore, other.relBefore) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private ClaimPredicateType discriminant;
        private ClaimPredicate[] andPredicates;
        private ClaimPredicate[] orPredicates;
        private ClaimPredicate notPredicate;
        private Int64 absBefore;
        private Int64 relBefore;

        public Builder discriminant(ClaimPredicateType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder andPredicates(ClaimPredicate[] andPredicates) {
            this.andPredicates = andPredicates;
            return this;
        }

        public Builder orPredicates(ClaimPredicate[] orPredicates) {
            this.orPredicates = orPredicates;
            return this;
        }

        public Builder notPredicate(ClaimPredicate notPredicate) {
            this.notPredicate = notPredicate;
            return this;
        }

        public Builder absBefore(Int64 absBefore) {
            this.absBefore = absBefore;
            return this;
        }

        public Builder relBefore(Int64 relBefore) {
            this.relBefore = relBefore;
            return this;
        }

        public ClaimPredicate build() {
            ClaimPredicate val = new ClaimPredicate();
            val.setDiscriminant(this.discriminant);
            val.setAndPredicates(this.andPredicates);
            val.setOrPredicates(this.orPredicates);
            val.setNotPredicate(this.notPredicate);
            val.setAbsBefore(this.absBefore);
            val.setRelBefore(this.relBefore);
            return val;
        }
    }
}

