/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class ClaimLiquidityAtom
implements XdrElement {
    private PoolID liquidityPoolID;
    private Asset assetSold;
    private Int64 amountSold;
    private Asset assetBought;
    private Int64 amountBought;

    public PoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    public void setLiquidityPoolID(PoolID value) {
        this.liquidityPoolID = value;
    }

    public Asset getAssetSold() {
        return this.assetSold;
    }

    public void setAssetSold(Asset value) {
        this.assetSold = value;
    }

    public Int64 getAmountSold() {
        return this.amountSold;
    }

    public void setAmountSold(Int64 value) {
        this.amountSold = value;
    }

    public Asset getAssetBought() {
        return this.assetBought;
    }

    public void setAssetBought(Asset value) {
        this.assetBought = value;
    }

    public Int64 getAmountBought() {
        return this.amountBought;
    }

    public void setAmountBought(Int64 value) {
        this.amountBought = value;
    }

    public static void encode(XdrDataOutputStream stream, ClaimLiquidityAtom encodedClaimLiquidityAtom) throws IOException {
        PoolID.encode(stream, encodedClaimLiquidityAtom.liquidityPoolID);
        Asset.encode(stream, encodedClaimLiquidityAtom.assetSold);
        Int64.encode(stream, encodedClaimLiquidityAtom.amountSold);
        Asset.encode(stream, encodedClaimLiquidityAtom.assetBought);
        Int64.encode(stream, encodedClaimLiquidityAtom.amountBought);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimLiquidityAtom.encode(stream, this);
    }

    public static ClaimLiquidityAtom decode(XdrDataInputStream stream) throws IOException {
        ClaimLiquidityAtom decodedClaimLiquidityAtom = new ClaimLiquidityAtom();
        decodedClaimLiquidityAtom.liquidityPoolID = PoolID.decode(stream);
        decodedClaimLiquidityAtom.assetSold = Asset.decode(stream);
        decodedClaimLiquidityAtom.amountSold = Int64.decode(stream);
        decodedClaimLiquidityAtom.assetBought = Asset.decode(stream);
        decodedClaimLiquidityAtom.amountBought = Int64.decode(stream);
        return decodedClaimLiquidityAtom;
    }

    public int hashCode() {
        return Objects.hashCode(this.liquidityPoolID, this.assetSold, this.amountSold, this.assetBought, this.amountBought);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClaimLiquidityAtom)) {
            return false;
        }
        ClaimLiquidityAtom other = (ClaimLiquidityAtom)object;
        return Objects.equal(this.liquidityPoolID, other.liquidityPoolID) && Objects.equal(this.assetSold, other.assetSold) && Objects.equal(this.amountSold, other.amountSold) && Objects.equal(this.assetBought, other.assetBought) && Objects.equal(this.amountBought, other.amountBought);
    }

    public static final class Builder {
        private PoolID liquidityPoolID;
        private Asset assetSold;
        private Int64 amountSold;
        private Asset assetBought;
        private Int64 amountBought;

        public Builder liquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
            return this;
        }

        public Builder assetSold(Asset assetSold) {
            this.assetSold = assetSold;
            return this;
        }

        public Builder amountSold(Int64 amountSold) {
            this.amountSold = amountSold;
            return this;
        }

        public Builder assetBought(Asset assetBought) {
            this.assetBought = assetBought;
            return this;
        }

        public Builder amountBought(Int64 amountBought) {
            this.amountBought = amountBought;
            return this;
        }

        public ClaimLiquidityAtom build() {
            ClaimLiquidityAtom val = new ClaimLiquidityAtom();
            val.setLiquidityPoolID(this.liquidityPoolID);
            val.setAssetSold(this.assetSold);
            val.setAmountSold(this.amountSold);
            val.setAssetBought(this.assetBought);
            val.setAmountBought(this.amountBought);
            return val;
        }
    }
}

