/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.ClaimAtomType;
import org.stellar.sdk.xdr.ClaimLiquidityAtom;
import org.stellar.sdk.xdr.ClaimOfferAtom;
import org.stellar.sdk.xdr.ClaimOfferAtomV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class ClaimAtom
implements XdrElement {
    ClaimAtomType type;
    private ClaimOfferAtomV0 v0;
    private ClaimOfferAtom orderBook;
    private ClaimLiquidityAtom liquidityPool;

    public ClaimAtomType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(ClaimAtomType value) {
        this.type = value;
    }

    public ClaimOfferAtomV0 getV0() {
        return this.v0;
    }

    public void setV0(ClaimOfferAtomV0 value) {
        this.v0 = value;
    }

    public ClaimOfferAtom getOrderBook() {
        return this.orderBook;
    }

    public void setOrderBook(ClaimOfferAtom value) {
        this.orderBook = value;
    }

    public ClaimLiquidityAtom getLiquidityPool() {
        return this.liquidityPool;
    }

    public void setLiquidityPool(ClaimLiquidityAtom value) {
        this.liquidityPool = value;
    }

    public static void encode(XdrDataOutputStream stream, ClaimAtom encodedClaimAtom) throws IOException {
        stream.writeInt(encodedClaimAtom.getDiscriminant().getValue());
        switch (encodedClaimAtom.getDiscriminant()) {
            case CLAIM_ATOM_TYPE_V0: {
                ClaimOfferAtomV0.encode(stream, encodedClaimAtom.v0);
                break;
            }
            case CLAIM_ATOM_TYPE_ORDER_BOOK: {
                ClaimOfferAtom.encode(stream, encodedClaimAtom.orderBook);
                break;
            }
            case CLAIM_ATOM_TYPE_LIQUIDITY_POOL: {
                ClaimLiquidityAtom.encode(stream, encodedClaimAtom.liquidityPool);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimAtom.encode(stream, this);
    }

    public static ClaimAtom decode(XdrDataInputStream stream) throws IOException {
        ClaimAtom decodedClaimAtom = new ClaimAtom();
        ClaimAtomType discriminant = ClaimAtomType.decode(stream);
        decodedClaimAtom.setDiscriminant(discriminant);
        switch (decodedClaimAtom.getDiscriminant()) {
            case CLAIM_ATOM_TYPE_V0: {
                decodedClaimAtom.v0 = ClaimOfferAtomV0.decode(stream);
                break;
            }
            case CLAIM_ATOM_TYPE_ORDER_BOOK: {
                decodedClaimAtom.orderBook = ClaimOfferAtom.decode(stream);
                break;
            }
            case CLAIM_ATOM_TYPE_LIQUIDITY_POOL: {
                decodedClaimAtom.liquidityPool = ClaimLiquidityAtom.decode(stream);
            }
        }
        return decodedClaimAtom;
    }

    public int hashCode() {
        return Objects.hashCode(this.v0, this.orderBook, this.liquidityPool, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClaimAtom)) {
            return false;
        }
        ClaimAtom other = (ClaimAtom)object;
        return Objects.equal(this.v0, other.v0) && Objects.equal(this.orderBook, other.orderBook) && Objects.equal(this.liquidityPool, other.liquidityPool) && Objects.equal(this.type, other.type);
    }

    public static final class Builder {
        private ClaimAtomType discriminant;
        private ClaimOfferAtomV0 v0;
        private ClaimOfferAtom orderBook;
        private ClaimLiquidityAtom liquidityPool;

        public Builder discriminant(ClaimAtomType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0(ClaimOfferAtomV0 v0) {
            this.v0 = v0;
            return this;
        }

        public Builder orderBook(ClaimOfferAtom orderBook) {
            this.orderBook = orderBook;
            return this;
        }

        public Builder liquidityPool(ClaimLiquidityAtom liquidityPool) {
            this.liquidityPool = liquidityPool;
            return this;
        }

        public ClaimAtom build() {
            ClaimAtom val = new ClaimAtom();
            val.setDiscriminant(this.discriminant);
            val.setV0(this.v0);
            val.setOrderBook(this.orderBook);
            val.setLiquidityPool(this.liquidityPool);
            return val;
        }
    }
}

