/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum BucketEntryType implements XdrElement
{
    METAENTRY(-1),
    LIVEENTRY(0),
    DEADENTRY(1),
    INITENTRY(2);

    private int mValue;

    private BucketEntryType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static BucketEntryType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case -1: {
                return METAENTRY;
            }
            case 0: {
                return LIVEENTRY;
            }
            case 1: {
                return DEADENTRY;
            }
            case 2: {
                return INITENTRY;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, BucketEntryType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        BucketEntryType.encode(stream, this);
    }
}

