/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AssetType implements XdrElement
{
    ASSET_TYPE_NATIVE(0),
    ASSET_TYPE_CREDIT_ALPHANUM4(1),
    ASSET_TYPE_CREDIT_ALPHANUM12(2),
    ASSET_TYPE_POOL_SHARE(3);

    private int mValue;

    private AssetType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static AssetType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ASSET_TYPE_NATIVE;
            }
            case 1: {
                return ASSET_TYPE_CREDIT_ALPHANUM4;
            }
            case 2: {
                return ASSET_TYPE_CREDIT_ALPHANUM12;
            }
            case 3: {
                return ASSET_TYPE_POOL_SHARE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, AssetType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AssetType.encode(stream, this);
    }
}

