/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.AssetCode;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class AllowTrustOp
implements XdrElement {
    private AccountID trustor;
    private AssetCode asset;
    private Uint32 authorize;

    public AccountID getTrustor() {
        return this.trustor;
    }

    public void setTrustor(AccountID value) {
        this.trustor = value;
    }

    public AssetCode getAsset() {
        return this.asset;
    }

    public void setAsset(AssetCode value) {
        this.asset = value;
    }

    public Uint32 getAuthorize() {
        return this.authorize;
    }

    public void setAuthorize(Uint32 value) {
        this.authorize = value;
    }

    public static void encode(XdrDataOutputStream stream, AllowTrustOp encodedAllowTrustOp) throws IOException {
        AccountID.encode(stream, encodedAllowTrustOp.trustor);
        AssetCode.encode(stream, encodedAllowTrustOp.asset);
        Uint32.encode(stream, encodedAllowTrustOp.authorize);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AllowTrustOp.encode(stream, this);
    }

    public static AllowTrustOp decode(XdrDataInputStream stream) throws IOException {
        AllowTrustOp decodedAllowTrustOp = new AllowTrustOp();
        decodedAllowTrustOp.trustor = AccountID.decode(stream);
        decodedAllowTrustOp.asset = AssetCode.decode(stream);
        decodedAllowTrustOp.authorize = Uint32.decode(stream);
        return decodedAllowTrustOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.trustor, this.asset, this.authorize);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AllowTrustOp)) {
            return false;
        }
        AllowTrustOp other = (AllowTrustOp)object;
        return Objects.equal(this.trustor, other.trustor) && Objects.equal(this.asset, other.asset) && Objects.equal(this.authorize, other.authorize);
    }

    public static final class Builder {
        private AccountID trustor;
        private AssetCode asset;
        private Uint32 authorize;

        public Builder trustor(AccountID trustor) {
            this.trustor = trustor;
            return this;
        }

        public Builder asset(AssetCode asset) {
            this.asset = asset;
            return this;
        }

        public Builder authorize(Uint32 authorize) {
            this.authorize = authorize;
            return this;
        }

        public AllowTrustOp build() {
            AllowTrustOp val = new AllowTrustOp();
            val.setTrustor(this.trustor);
            val.setAsset(this.asset);
            val.setAuthorize(this.authorize);
            return val;
        }
    }
}

