/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AccountMergeResultCode implements XdrElement
{
    ACCOUNT_MERGE_SUCCESS(0),
    ACCOUNT_MERGE_MALFORMED(-1),
    ACCOUNT_MERGE_NO_ACCOUNT(-2),
    ACCOUNT_MERGE_IMMUTABLE_SET(-3),
    ACCOUNT_MERGE_HAS_SUB_ENTRIES(-4),
    ACCOUNT_MERGE_SEQNUM_TOO_FAR(-5),
    ACCOUNT_MERGE_DEST_FULL(-6),
    ACCOUNT_MERGE_IS_SPONSOR(-7);

    private int mValue;

    private AccountMergeResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static AccountMergeResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ACCOUNT_MERGE_SUCCESS;
            }
            case -1: {
                return ACCOUNT_MERGE_MALFORMED;
            }
            case -2: {
                return ACCOUNT_MERGE_NO_ACCOUNT;
            }
            case -3: {
                return ACCOUNT_MERGE_IMMUTABLE_SET;
            }
            case -4: {
                return ACCOUNT_MERGE_HAS_SUB_ENTRIES;
            }
            case -5: {
                return ACCOUNT_MERGE_SEQNUM_TOO_FAR;
            }
            case -6: {
                return ACCOUNT_MERGE_DEST_FULL;
            }
            case -7: {
                return ACCOUNT_MERGE_IS_SPONSOR;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, AccountMergeResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AccountMergeResultCode.encode(stream, this);
    }
}

