/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import java.util.List;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.common.base.Optional;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.gson.annotations.SerializedName;

public abstract class PathPaymentBaseOperationResponse
extends OperationResponse {
    @SerializedName(value="amount")
    private String amount;
    @SerializedName(value="source_amount")
    private String sourceAmount;
    @SerializedName(value="from")
    private String from;
    @SerializedName(value="from_muxed")
    private String fromMuxed;
    @SerializedName(value="from_muxed_id")
    private Long fromMuxedId;
    @SerializedName(value="to")
    private String to;
    @SerializedName(value="to_muxed")
    private String toMuxed;
    @SerializedName(value="to_muxed_id")
    private Long toMuxedId;
    @SerializedName(value="asset_type")
    private String assetType;
    @SerializedName(value="asset_code")
    private String assetCode;
    @SerializedName(value="asset_issuer")
    private String assetIssuer;
    @SerializedName(value="source_asset_type")
    private String sourceAssetType;
    @SerializedName(value="source_asset_code")
    private String sourceAssetCode;
    @SerializedName(value="source_asset_issuer")
    private String sourceAssetIssuer;
    @SerializedName(value="path")
    private ImmutableList<Asset> path;

    public String getAmount() {
        return this.amount;
    }

    public String getSourceAmount() {
        return this.sourceAmount;
    }

    public String getFrom() {
        return this.from;
    }

    public Optional<MuxedAccount> getFromMuxed() {
        if (this.fromMuxed == null || this.fromMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.fromMuxed, this.from, this.fromMuxedId));
    }

    public Optional<MuxedAccount> getToMuxed() {
        if (this.toMuxed == null || this.toMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.toMuxed, this.to, this.toMuxedId));
    }

    public String getTo() {
        return this.to;
    }

    public List<Asset> getPath() {
        return this.path;
    }

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }

    public Asset getSourceAsset() {
        if (this.sourceAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.sourceAssetCode, this.sourceAssetIssuer);
    }
}

