/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.responses.TransactionResponse;
import shadow.com.google.common.base.Optional;
import shadow.com.google.gson.annotations.SerializedName;

public abstract class OperationResponse
extends Response
implements Pageable {
    @SerializedName(value="id")
    private Long id;
    @SerializedName(value="source_account")
    private String sourceAccount;
    @SerializedName(value="source_account_muxed")
    private String sourceAccountMuxed;
    @SerializedName(value="source_account_muxed_id")
    private Long sourceAccountMuxedId;
    @SerializedName(value="paging_token")
    private String pagingToken;
    @SerializedName(value="created_at")
    private String createdAt;
    @SerializedName(value="transaction_hash")
    private String transactionHash;
    @SerializedName(value="transaction_successful")
    private Boolean transactionSuccessful;
    @SerializedName(value="type")
    private String type;
    @SerializedName(value="_links")
    private Links links;
    @SerializedName(value="transaction")
    private TransactionResponse transaction;

    public Optional<MuxedAccount> getSourceAccountMuxed() {
        if (this.sourceAccountMuxed == null || this.sourceAccountMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.sourceAccountMuxed, this.sourceAccount, this.sourceAccountMuxedId));
    }

    public Long getId() {
        return this.id;
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    @Override
    public String getPagingToken() {
        return this.pagingToken;
    }

    public String getType() {
        return this.type;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public Boolean isTransactionSuccessful() {
        return this.transactionSuccessful;
    }

    public Links getLinks() {
        return this.links;
    }

    public Optional<TransactionResponse> getTransaction() {
        return Optional.fromNullable(this.transaction);
    }

    public static class Links {
        @SerializedName(value="effects")
        private final Link effects;
        @SerializedName(value="precedes")
        private final Link precedes;
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="succeeds")
        private final Link succeeds;
        @SerializedName(value="transaction")
        private final Link transaction;

        public Links(Link effects, Link precedes, Link self, Link succeeds, Link transaction) {
            this.effects = effects;
            this.precedes = precedes;
            this.self = self;
            this.succeeds = succeeds;
            this.transaction = transaction;
        }

        public Link getEffects() {
            return this.effects;
        }

        public Link getPrecedes() {
            return this.precedes;
        }

        public Link getSelf() {
            return this.self;
        }

        public Link getSucceeds() {
            return this.succeeds;
        }

        public Link getTransaction() {
            return this.transaction;
        }
    }
}

