/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.gson.annotations.SerializedName;

public class CreatePassiveSellOfferOperationResponse
extends OperationResponse {
    @SerializedName(value="offer_id")
    protected final Long offerId;
    @SerializedName(value="amount")
    protected final String amount;
    @SerializedName(value="price")
    protected final String price;
    @SerializedName(value="buying_asset_type")
    protected final String buyingAssetType;
    @SerializedName(value="buying_asset_code")
    protected final String buyingAssetCode;
    @SerializedName(value="buying_asset_issuer")
    protected final String buyingAssetIssuer;
    @SerializedName(value="selling_asset_type")
    protected final String sellingAssetType;
    @SerializedName(value="selling_asset_code")
    protected final String sellingAssetCode;
    @SerializedName(value="selling_asset_issuer")
    protected final String sellingAssetIssuer;

    CreatePassiveSellOfferOperationResponse(Long offerId, String amount, String price, String buyingAssetType, String buyingAssetCode, String buyingAssetIssuer, String sellingAssetType, String sellingAssetCode, String sellingAssetIssuer) {
        this.offerId = offerId;
        this.amount = amount;
        this.price = price;
        this.buyingAssetType = buyingAssetType;
        this.buyingAssetCode = buyingAssetCode;
        this.buyingAssetIssuer = buyingAssetIssuer;
        this.sellingAssetType = sellingAssetType;
        this.sellingAssetCode = sellingAssetCode;
        this.sellingAssetIssuer = sellingAssetIssuer;
    }

    public Long getOfferId() {
        return this.offerId;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getPrice() {
        return this.price;
    }

    public Asset getBuyingAsset() {
        if (this.buyingAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.buyingAssetCode, this.buyingAssetIssuer);
    }

    public Asset getSellingAsset() {
        if (this.sellingAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.sellingAssetCode, this.sellingAssetIssuer);
    }
}

