/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.common.base.Optional;
import shadow.com.google.gson.annotations.SerializedName;

public class ClawbackOperationResponse
extends OperationResponse {
    @SerializedName(value="asset_type")
    private String assetType;
    @SerializedName(value="asset_code")
    private String assetCode;
    @SerializedName(value="asset_issuer")
    private String assetIssuer;
    @SerializedName(value="amount")
    private String amount;
    @SerializedName(value="from")
    private String from;
    @SerializedName(value="from_muxed")
    private String fromMuxed;
    @SerializedName(value="from_muxed_id")
    private Long fromMuxedId;

    public String getAssetType() {
        return this.assetType;
    }

    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    public String getAssetCode() {
        return this.assetCode;
    }

    public Asset getAsset() {
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }

    public String getAmount() {
        return this.amount;
    }

    public String getFrom() {
        return this.from;
    }

    public Optional<MuxedAccount> getFromMuxed() {
        if (this.fromMuxed == null || this.fromMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.fromMuxed, this.from, this.fromMuxedId));
    }
}

