/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.common.base.Optional;
import shadow.com.google.gson.annotations.SerializedName;

public class ChangeTrustOperationResponse
extends OperationResponse {
    @SerializedName(value="trustor")
    private String trustor;
    @SerializedName(value="trustor_muxed")
    private String trustorMuxed;
    @SerializedName(value="trustor_muxed_id")
    private Long trustorMuxedId;
    @SerializedName(value="trustee")
    private String trustee;
    @SerializedName(value="asset_type")
    private String assetType;
    @SerializedName(value="asset_code")
    private String assetCode;
    @SerializedName(value="asset_issuer")
    private String assetIssuer;
    @SerializedName(value="limit")
    private String limit;

    public Optional<MuxedAccount> getTrustorMuxed() {
        if (this.trustorMuxed == null || this.trustorMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.trustorMuxed, this.trustor, this.trustorMuxedId));
    }

    public String getTrustor() {
        return this.trustor;
    }

    public String getTrustee() {
        return this.trustee;
    }

    public String getLimit() {
        return this.limit;
    }

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }
}

