/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.common.base.Optional;
import shadow.com.google.gson.annotations.SerializedName;

public class AllowTrustOperationResponse
extends OperationResponse {
    @SerializedName(value="trustor")
    private String trustor;
    @SerializedName(value="trustee")
    private String trustee;
    @SerializedName(value="trustee_muxed")
    private String trusteeMuxed;
    @SerializedName(value="trustee_muxed_id")
    private Long trusteeMuxedId;
    @SerializedName(value="asset_type")
    private String assetType;
    @SerializedName(value="asset_code")
    private String assetCode;
    @SerializedName(value="asset_issuer")
    private String assetIssuer;
    @SerializedName(value="authorize")
    private boolean authorize;
    @SerializedName(value="authorize_to_maintain_liabilities")
    private boolean authorizeToMaintainLiabilities;

    public String getTrustor() {
        return this.trustor;
    }

    public Optional<MuxedAccount> getTrusteeMuxed() {
        if (this.trusteeMuxed == null || this.trusteeMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.trusteeMuxed, this.trustee, this.trusteeMuxedId));
    }

    public String getTrustee() {
        return this.trustee;
    }

    public boolean isAuthorize() {
        return this.authorize;
    }

    public boolean isAuthorizedToMaintainLiabilities() {
        return this.authorizeToMaintainLiabilities;
    }

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }
}

