/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.effects;

import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.effects.EffectResponse;
import shadow.com.google.gson.annotations.SerializedName;

public class TrustlineFlagsUpdatedEffectResponse
extends EffectResponse {
    @SerializedName(value="trustor")
    protected final String trustor;
    @SerializedName(value="asset_type")
    protected final String assetType;
    @SerializedName(value="asset_code")
    protected final String assetCode;
    @SerializedName(value="asset_issuer")
    protected final String assetIssuer;
    @SerializedName(value="authorized_flag")
    protected final boolean authorized;
    @SerializedName(value="authorized_to_maintain_liabilites_flag")
    protected final boolean authorizedToMaintainLiabilities;
    @SerializedName(value="clawback_enabled_flag")
    protected final boolean clawbackEnabled;

    public TrustlineFlagsUpdatedEffectResponse(String trustor, String assetType, String assetCode, String assetIssuer, boolean authorized, boolean authorizedToMaintainLiabilities, boolean clawbackEnabled) {
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.assetType = assetType;
        this.trustor = trustor;
        this.authorized = authorized;
        this.authorizedToMaintainLiabilities = authorizedToMaintainLiabilities;
        this.clawbackEnabled = clawbackEnabled;
    }

    public String getTrustor() {
        return this.trustor;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    public String getAssetCode() {
        return this.assetCode;
    }

    public Asset getAsset() {
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }

    public boolean getAuthorized() {
        return this.authorized;
    }

    public boolean getAuthorizedToMaintainLiabilities() {
        return this.authorizedToMaintainLiabilities;
    }

    public boolean getClawbackEnabled() {
        return this.clawbackEnabled;
    }
}

