/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.effects;

import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import shadow.com.google.common.base.Optional;
import shadow.com.google.gson.annotations.SerializedName;

public abstract class EffectResponse
extends Response
implements Pageable {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="account")
    private String account;
    @SerializedName(value="account_muxed")
    private String accountMuxed;
    @SerializedName(value="account_muxed_id")
    private Long accountMuxedId;
    @SerializedName(value="type")
    private String type;
    @SerializedName(value="created_at")
    private String createdAt;
    @SerializedName(value="paging_token")
    private String pagingToken;
    @SerializedName(value="_links")
    private Links links;

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Optional<MuxedAccount> getAccountMuxed() {
        if (this.accountMuxed == null || this.accountMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.accountMuxed, this.account, this.accountMuxedId));
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getPagingToken() {
        return this.pagingToken;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="operation")
        private final Link operation;
        @SerializedName(value="precedes")
        private final Link precedes;
        @SerializedName(value="succeeds")
        private final Link succeeds;

        public Links(Link operation, Link precedes, Link succeeds) {
            this.operation = operation;
            this.precedes = precedes;
            this.succeeds = succeeds;
        }

        public Link getOperation() {
            return this.operation;
        }

        public Link getPrecedes() {
            return this.precedes;
        }

        public Link getSucceeds() {
            return this.succeeds;
        }
    }
}

