/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.util.List;
import org.stellar.sdk.Memo;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import shadow.com.google.common.base.Optional;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.gson.annotations.SerializedName;

public class TransactionResponse
extends Response
implements Pageable {
    @SerializedName(value="hash")
    private String hash;
    @SerializedName(value="ledger")
    private Long ledger;
    @SerializedName(value="created_at")
    private String createdAt;
    @SerializedName(value="source_account")
    private String sourceAccount;
    @SerializedName(value="fee_account")
    private String feeAccount;
    @SerializedName(value="successful")
    private Boolean successful;
    @SerializedName(value="paging_token")
    private String pagingToken;
    @SerializedName(value="source_account_sequence")
    private Long sourceAccountSequence;
    @SerializedName(value="max_fee")
    private Long maxFee;
    @SerializedName(value="fee_charged")
    private Long feeCharged;
    @SerializedName(value="operation_count")
    private Integer operationCount;
    @SerializedName(value="envelope_xdr")
    private String envelopeXdr;
    @SerializedName(value="result_xdr")
    private String resultXdr;
    @SerializedName(value="result_meta_xdr")
    private String resultMetaXdr;
    @SerializedName(value="signatures")
    private List<String> signatures;
    @SerializedName(value="fee_bump_transaction")
    private FeeBumpTransaction feeBumpTransaction;
    @SerializedName(value="inner_transaction")
    private InnerTransaction innerTransaction;
    @SerializedName(value="account_muxed")
    private String accountMuxed;
    @SerializedName(value="account_muxed_id")
    private Long accountMuxedId;
    @SerializedName(value="fee_account_muxed")
    private String feeAccountMuxed;
    @SerializedName(value="fee_account_muxed_id")
    private Long feeAccountMuxedId;
    @SerializedName(value="_links")
    private Links links;
    private transient Memo memo;

    public Optional<MuxedAccount> getSourceAccountMuxed() {
        if (this.accountMuxed == null || this.accountMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.accountMuxed, this.sourceAccount, this.accountMuxedId));
    }

    public Optional<MuxedAccount> getFeeAccountMuxed() {
        if (this.feeAccountMuxed == null || this.feeAccountMuxed.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(new MuxedAccount(this.feeAccountMuxed, this.feeAccount, this.feeAccountMuxedId));
    }

    public String getHash() {
        return this.hash;
    }

    public Long getLedger() {
        return this.ledger;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public String getFeeAccount() {
        return this.feeAccount;
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    public Optional<FeeBumpTransaction> getFeeBump() {
        return Optional.fromNullable(this.feeBumpTransaction);
    }

    public Optional<InnerTransaction> getInner() {
        return Optional.fromNullable(this.innerTransaction);
    }

    @Override
    public String getPagingToken() {
        return this.pagingToken;
    }

    public Boolean isSuccessful() {
        return this.successful;
    }

    public Long getSourceAccountSequence() {
        return this.sourceAccountSequence;
    }

    public Long getMaxFee() {
        return this.maxFee;
    }

    public Long getFeeCharged() {
        return this.feeCharged;
    }

    public Integer getOperationCount() {
        return this.operationCount;
    }

    public String getEnvelopeXdr() {
        return this.envelopeXdr;
    }

    public String getResultXdr() {
        return this.resultXdr;
    }

    public String getResultMetaXdr() {
        return this.resultMetaXdr;
    }

    public Memo getMemo() {
        return this.memo;
    }

    public void setMemo(Memo memo) {
        memo = Preconditions.checkNotNull(memo, "memo cannot be null");
        if (this.memo != null) {
            throw new RuntimeException("Memo has been already set.");
        }
        this.memo = memo;
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="account")
        private Link account;
        @SerializedName(value="effects")
        private Link effects;
        @SerializedName(value="ledger")
        private Link ledger;
        @SerializedName(value="operations")
        private Link operations;
        @SerializedName(value="precedes")
        private Link precedes;
        @SerializedName(value="self")
        private Link self;
        @SerializedName(value="succeeds")
        private Link succeeds;

        Links(Link account, Link effects, Link ledger, Link operations, Link self, Link precedes, Link succeeds) {
            this.account = account;
            this.effects = effects;
            this.ledger = ledger;
            this.operations = operations;
            this.self = self;
            this.precedes = precedes;
            this.succeeds = succeeds;
        }

        public Link getAccount() {
            return this.account;
        }

        public Link getEffects() {
            return this.effects;
        }

        public Link getLedger() {
            return this.ledger;
        }

        public Link getOperations() {
            return this.operations;
        }

        public Link getPrecedes() {
            return this.precedes;
        }

        public Link getSelf() {
            return this.self;
        }

        public Link getSucceeds() {
            return this.succeeds;
        }
    }

    public static class InnerTransaction {
        @SerializedName(value="hash")
        private String hash;
        @SerializedName(value="signatures")
        private List<String> signatures;
        @SerializedName(value="max_fee")
        private Long maxFee;

        InnerTransaction(String hash, List<String> signatures, Long maxFee) {
            this.hash = hash;
            this.signatures = signatures;
            this.maxFee = maxFee;
        }

        public String getHash() {
            return this.hash;
        }

        public List<String> getSignatures() {
            return this.signatures;
        }

        public Long getMaxFee() {
            return this.maxFee;
        }
    }

    public static class FeeBumpTransaction {
        @SerializedName(value="hash")
        private String hash;
        @SerializedName(value="signatures")
        private List<String> signatures;

        FeeBumpTransaction(String hash, List<String> signatures) {
            this.hash = hash;
            this.signatures = signatures;
        }

        public String getHash() {
            return this.hash;
        }

        public List<String> getSignatures() {
            return this.signatures;
        }
    }
}

