/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import org.stellar.sdk.Memo;
import org.stellar.sdk.responses.TransactionResponse;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.XdrDataInputStream;
import shadow.com.google.common.io.BaseEncoding;
import shadow.com.google.gson.Gson;
import shadow.com.google.gson.GsonBuilder;
import shadow.com.google.gson.JsonDeserializationContext;
import shadow.com.google.gson.JsonDeserializer;
import shadow.com.google.gson.JsonElement;
import shadow.com.google.gson.JsonObject;
import shadow.com.google.gson.JsonParseException;

public class TransactionDeserializer
implements JsonDeserializer<TransactionResponse> {
    private Memo extractTextMemo(TransactionEnvelope transactionEnvelope) {
        switch (transactionEnvelope.getDiscriminant()) {
            case ENVELOPE_TYPE_TX: {
                return Memo.text(transactionEnvelope.getV1().getTx().getMemo().getText().getBytes());
            }
            case ENVELOPE_TYPE_TX_V0: {
                return Memo.text(transactionEnvelope.getV0().getTx().getMemo().getText().getBytes());
            }
            case ENVELOPE_TYPE_TX_FEE_BUMP: {
                return Memo.text(transactionEnvelope.getFeeBump().getTx().getInnerTx().getV1().getTx().getMemo().getText().getBytes());
            }
        }
        throw new IllegalArgumentException("invalid transaction type: " + transactionEnvelope.getDiscriminant());
    }

    @Override
    public TransactionResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Memo memo;
        Gson gson = new GsonBuilder().create();
        TransactionResponse transaction = gson.fromJson(json, TransactionResponse.class);
        String memoType = json.getAsJsonObject().get("memo_type").getAsString();
        if (memoType.equals("none")) {
            memo = Memo.none();
        } else if (memoType.equals("text")) {
            BaseEncoding base64Encoding = BaseEncoding.base64();
            JsonObject jsonResponse = json.getAsJsonObject();
            if (jsonResponse.has("memo_bytes")) {
                String memoBase64 = json.getAsJsonObject().get("memo_bytes").getAsString();
                memo = Memo.text(base64Encoding.decode(memoBase64));
            } else {
                String envelopeXdr = json.getAsJsonObject().get("envelope_xdr").getAsString();
                byte[] bytes = base64Encoding.decode(envelopeXdr);
                TransactionEnvelope transactionEnvelope = null;
                try {
                    transactionEnvelope = TransactionEnvelope.decode(new XdrDataInputStream(new ByteArrayInputStream(bytes)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                memo = this.extractTextMemo(transactionEnvelope);
            }
        } else {
            String memoValue = json.getAsJsonObject().get("memo").getAsString();
            BaseEncoding base64Encoding = BaseEncoding.base64();
            if (memoType.equals("id")) {
                memo = Memo.id(Long.parseUnsignedLong(memoValue));
            } else if (memoType.equals("hash")) {
                memo = Memo.hash(base64Encoding.decode(memoValue));
            } else if (memoType.equals("return")) {
                memo = Memo.returnHash(base64Encoding.decode(memoValue));
            } else {
                throw new JsonParseException("Unknown memo type.");
            }
        }
        transaction.setMemo(memo);
        return transaction;
    }
}

