/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.math.BigDecimal;
import java.math.MathContext;
import shadow.com.google.common.base.Objects;
import shadow.com.google.gson.annotations.SerializedName;

public class TradePrice {
    @SerializedName(value="n")
    private final Long n;
    @SerializedName(value="d")
    private final Long d;

    public TradePrice(Long n, Long d) {
        this.n = n;
        this.d = d;
    }

    public Long getNumerator() {
        return this.n;
    }

    public Long getDenominator() {
        return this.d;
    }

    public String toString() {
        MathContext mc = MathContext.DECIMAL64;
        BigDecimal result = new BigDecimal(this.n).divide(new BigDecimal(this.d), mc);
        return result.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.getNumerator(), this.getDenominator());
    }

    public boolean equals(Object object) {
        if (!(object instanceof TradePrice)) {
            return false;
        }
        TradePrice other = (TradePrice)object;
        return this.getNumerator() == other.getNumerator() && this.getDenominator() == other.getDenominator();
    }
}

