/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.xdr.OperationResult;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.TransactionResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import shadow.com.google.common.base.Optional;
import shadow.com.google.common.io.BaseEncoding;
import shadow.com.google.gson.annotations.SerializedName;

public class SubmitTransactionResponse
extends Response {
    @SerializedName(value="hash")
    private final String hash;
    @SerializedName(value="ledger")
    private final Long ledger;
    @SerializedName(value="envelope_xdr")
    private final String envelopeXdr;
    @SerializedName(value="result_xdr")
    private final String resultXdr;
    @SerializedName(value="extras")
    private final Extras extras;
    private TransactionResult transactionResult;

    SubmitTransactionResponse(Extras extras, Long ledger, String hash, String envelopeXdr, String resultXdr) {
        this.extras = extras;
        this.ledger = ledger;
        this.hash = hash;
        this.envelopeXdr = envelopeXdr;
        this.resultXdr = resultXdr;
    }

    public boolean isSuccess() {
        return this.ledger != null;
    }

    public String getHash() {
        return this.hash;
    }

    public Long getLedger() {
        return this.ledger;
    }

    public Optional<String> getEnvelopeXdr() {
        if (this.isSuccess()) {
            return Optional.of(this.envelopeXdr);
        }
        if (this.getExtras() != null) {
            return Optional.of(this.getExtras().getEnvelopeXdr());
        }
        return Optional.absent();
    }

    public Optional<String> getResultXdr() {
        if (this.isSuccess()) {
            return Optional.of(this.resultXdr);
        }
        if (this.getExtras() != null) {
            return Optional.of(this.getExtras().getResultXdr());
        }
        return Optional.absent();
    }

    public Optional<Long> getOfferIdFromResult(int position) throws IOException {
        if (!this.isSuccess()) {
            return Optional.absent();
        }
        Optional<TransactionResult> optionalResult = this.getDecodedTransactionResult();
        if (!optionalResult.isPresent()) {
            return Optional.absent();
        }
        TransactionResult result = optionalResult.get();
        if (result.getResult().getResults()[position] == null) {
            return Optional.absent();
        }
        OperationResult operationResult = result.getResult().getResults()[position];
        OperationType operationType = operationResult.getTr().getDiscriminant();
        OperationResult.OperationResultTr operationResultTr = operationResult.getTr();
        if (operationType == OperationType.MANAGE_SELL_OFFER) {
            if (operationResultTr.getManageSellOfferResult().getSuccess().getOffer().getOffer() == null) {
                return Optional.absent();
            }
            return Optional.of(operationResultTr.getManageSellOfferResult().getSuccess().getOffer().getOffer().getOfferID().getInt64());
        }
        if (operationType == OperationType.MANAGE_BUY_OFFER) {
            if (operationResultTr.getManageBuyOfferResult().getSuccess().getOffer().getOffer() == null) {
                return Optional.absent();
            }
            return Optional.of(operationResultTr.getManageBuyOfferResult().getSuccess().getOffer().getOffer().getOfferID().getInt64());
        }
        return Optional.absent();
    }

    public Optional<TransactionResult> getDecodedTransactionResult() throws IOException {
        if (!this.isSuccess()) {
            return Optional.absent();
        }
        if (this.transactionResult == null) {
            Optional<String> resultXDR = this.getResultXdr();
            if (!resultXDR.isPresent()) {
                return Optional.absent();
            }
            BaseEncoding base64Encoding = BaseEncoding.base64();
            byte[] bytes = base64Encoding.decode(resultXDR.get());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            XdrDataInputStream xdrInputStream = new XdrDataInputStream(inputStream);
            this.transactionResult = TransactionResult.decode(xdrInputStream);
        }
        return Optional.of(this.transactionResult);
    }

    public Extras getExtras() {
        return this.extras;
    }

    public static class Extras {
        @SerializedName(value="envelope_xdr")
        private final String envelopeXdr;
        @SerializedName(value="result_xdr")
        private final String resultXdr;
        @SerializedName(value="result_codes")
        private final ResultCodes resultCodes;

        Extras(String envelopeXdr, String resultXdr, ResultCodes resultCodes) {
            this.envelopeXdr = envelopeXdr;
            this.resultXdr = resultXdr;
            this.resultCodes = resultCodes;
        }

        public String getEnvelopeXdr() {
            return this.envelopeXdr;
        }

        public String getResultXdr() {
            return this.resultXdr;
        }

        public ResultCodes getResultCodes() {
            return this.resultCodes;
        }

        public static class ResultCodes {
            @SerializedName(value="transaction")
            private final String transactionResultCode;
            @SerializedName(value="operations")
            private final ArrayList<String> operationsResultCodes;

            public ResultCodes(String transactionResultCode, ArrayList<String> operationsResultCodes) {
                this.transactionResultCode = transactionResultCode;
                this.operationsResultCodes = operationsResultCodes;
            }

            public String getTransactionResultCode() {
                return this.transactionResultCode;
            }

            public ArrayList<String> getOperationsResultCodes() {
                return this.operationsResultCodes;
            }
        }
    }
}

