/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import org.stellar.sdk.Asset;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.xdr.LiquidityPoolType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.gson.annotations.SerializedName;

public class LiquidityPoolResponse
extends Response {
    @SerializedName(value="id")
    private LiquidityPoolID id;
    @SerializedName(value="paging_token")
    private String pagingToken;
    @SerializedName(value="fee_bp")
    private Integer feeBP;
    @SerializedName(value="type")
    private LiquidityPoolType type;
    @SerializedName(value="total_trustlines")
    private Long totalTrustlines;
    @SerializedName(value="total_shares")
    private String totalShares;
    @SerializedName(value="reserves")
    private Reserve[] reserves;
    @SerializedName(value="_links")
    private Links links;

    LiquidityPoolResponse(LiquidityPoolID id) {
        this.id = id;
    }

    public LiquidityPoolID getID() {
        return this.id;
    }

    public String getPagingToken() {
        return this.pagingToken;
    }

    public Integer getFeeBP() {
        return this.feeBP;
    }

    public LiquidityPoolType getType() {
        return this.type;
    }

    public Long getTotalTrustlines() {
        return this.totalTrustlines;
    }

    public String getTotalShares() {
        return this.totalShares;
    }

    public Reserve[] getReserves() {
        return this.reserves;
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="effects")
        private final Link effects;
        @SerializedName(value="operations")
        private final Link operations;
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="transactions")
        private final Link transactions;

        Links(Link effects, Link operations, Link self, Link transactions) {
            this.effects = effects;
            this.operations = operations;
            this.self = self;
            this.transactions = transactions;
        }

        public Link getEffects() {
            return this.effects;
        }

        public Link getOperations() {
            return this.operations;
        }

        public Link getSelf() {
            return this.self;
        }

        public Link getTransactions() {
            return this.transactions;
        }
    }

    public static class Reserve {
        @SerializedName(value="amount")
        private final String amount;
        @SerializedName(value="asset")
        private final Asset asset;

        public Reserve(String amount, String asset) {
            this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
            this.asset = Asset.create(Preconditions.checkNotNull(asset, "asset cannot be null"));
        }

        public Reserve(String amount, Asset asset) {
            this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
            this.asset = Preconditions.checkNotNull(asset, "asset cannot be null");
        }

        public Asset getAsset() {
            return this.asset;
        }

        public String getAmount() {
            return this.amount;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Reserve)) {
                return false;
            }
            Reserve o = (Reserve)other;
            return Objects.equal(this.getAsset(), o.getAsset()) && Objects.equal(this.getAmount(), o.getAmount());
        }
    }
}

