/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import java.util.List;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Claimant;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import shadow.com.google.common.base.Optional;
import shadow.com.google.gson.annotations.SerializedName;

public class ClaimableBalanceResponse
extends Response
implements Pageable {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="asset")
    private final String assetString;
    @SerializedName(value="amount")
    private final String amount;
    @SerializedName(value="sponsor")
    private final String sponsor;
    @SerializedName(value="last_modified_ledger")
    private final Integer lastModifiedLedger;
    @SerializedName(value="last_modified_time")
    private final String lastModifiedTime;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="_links")
    private final Links links;
    @SerializedName(value="claimants")
    private final List<Claimant> claimants;

    public ClaimableBalanceResponse(String id, String assetString, String amount, String sponsor, Integer lastModifiedLedger, String lastModifiedTime, String pagingToken, List<Claimant> claimants, Links links) {
        this.id = id;
        this.assetString = assetString;
        this.amount = amount;
        this.sponsor = sponsor;
        this.lastModifiedLedger = lastModifiedLedger;
        this.lastModifiedTime = lastModifiedTime;
        this.pagingToken = pagingToken;
        this.claimants = claimants;
        this.links = links;
    }

    public String getId() {
        return this.id;
    }

    public String getAssetString() {
        return this.assetString;
    }

    public Asset getAsset() {
        return Asset.create(this.assetString);
    }

    public String getAmount() {
        return this.amount;
    }

    public Integer getLastModifiedLedger() {
        return this.lastModifiedLedger;
    }

    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Optional<String> getSponsor() {
        return Optional.fromNullable(this.sponsor);
    }

    @Override
    public String getPagingToken() {
        return this.pagingToken;
    }

    public Links getLinks() {
        return this.links;
    }

    public List<Claimant> getClaimants() {
        return this.claimants;
    }

    public static class Links {
        @SerializedName(value="self")
        private final Link self;

        public Links(Link self) {
            this.self = self;
        }

        public Link getSelf() {
            return this.self;
        }
    }
}

