/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import shadow.com.google.gson.annotations.SerializedName;

public class AssetResponse
extends Response
implements Pageable {
    @SerializedName(value="asset_type")
    private final String assetType;
    @SerializedName(value="asset_code")
    private final String assetCode;
    @SerializedName(value="asset_issuer")
    private final String assetIssuer;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="accounts")
    private final Accounts accounts;
    @SerializedName(value="balances")
    private final Balances balances;
    @SerializedName(value="amount")
    private final String amount;
    @SerializedName(value="claimable_balances_amount")
    private final String claimableBalancesAmount;
    @SerializedName(value="liquidity_pools_amount")
    private final String liquidityPoolsAmount;
    @SerializedName(value="num_accounts")
    private final int numAccounts;
    @SerializedName(value="num_claimable_balances")
    private final int numClaimableBalances;
    @SerializedName(value="num_liquidity_pools")
    private final int numLiquidityPools;
    @SerializedName(value="flags")
    private final Flags flags;
    @SerializedName(value="_links")
    private final Links links;

    public AssetResponse(String assetType, String assetCode, String assetIssuer, String pagingToken, Accounts accounts, Balances balances, String amount, String claimableBalancesAmount, String liquidityPoolsAmount, int numAccounts, int numClaimableBalances, int numLiquidityPools, Flags flags, Links links) {
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.pagingToken = pagingToken;
        this.accounts = accounts;
        this.balances = balances;
        this.amount = amount;
        this.claimableBalancesAmount = claimableBalancesAmount;
        this.liquidityPoolsAmount = liquidityPoolsAmount;
        this.numAccounts = numAccounts;
        this.numClaimableBalances = numClaimableBalances;
        this.numLiquidityPools = numLiquidityPools;
        this.flags = flags;
        this.links = links;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public String getAssetCode() {
        return this.assetCode;
    }

    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    public Asset getAsset() {
        return Asset.create(this.assetType, this.assetCode, this.assetIssuer);
    }

    @Override
    public String getPagingToken() {
        return this.pagingToken;
    }

    public Accounts getAccounts() {
        return this.accounts;
    }

    public Balances getBalances() {
        return this.balances;
    }

    public String getClaimableBalancesAmount() {
        return this.claimableBalancesAmount;
    }

    public String getLiquidityPoolsAmount() {
        return this.liquidityPoolsAmount;
    }

    public int getNumClaimableBalances() {
        return this.numClaimableBalances;
    }

    public int getNumLiquidityPools() {
        return this.numLiquidityPools;
    }

    public String getAmount() {
        return this.amount;
    }

    public int getNumAccounts() {
        return this.numAccounts;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public Links getLinks() {
        return this.links;
    }

    public static class Links {
        @SerializedName(value="toml")
        private final Link toml;

        public Links(Link toml) {
            this.toml = toml;
        }

        public Link getToml() {
            return this.toml;
        }
    }

    public static class Flags {
        @SerializedName(value="auth_required")
        private final boolean authRequired;
        @SerializedName(value="auth_revocable")
        private final boolean authRevocable;

        public Flags(boolean authRequired, boolean authRevocable) {
            this.authRequired = authRequired;
            this.authRevocable = authRevocable;
        }

        public boolean isAuthRequired() {
            return this.authRequired;
        }

        public boolean isAuthRevocable() {
            return this.authRevocable;
        }
    }

    public static class Balances {
        @SerializedName(value="authorized")
        private final String authorized;
        @SerializedName(value="authorized_to_maintain_liabilities")
        private final String authorizedToMaintainLiabilities;
        @SerializedName(value="unauthorized")
        private final String unauthorized;

        public Balances(String authorized, String authorizedToMaintainLiabilities, String unauthorized) {
            this.authorized = authorized;
            this.authorizedToMaintainLiabilities = authorizedToMaintainLiabilities;
            this.unauthorized = unauthorized;
        }

        public String authorized() {
            return this.authorized;
        }

        public String authorizedToMaintainLiabilities() {
            return this.authorizedToMaintainLiabilities;
        }

        public String unauthorized() {
            return this.unauthorized;
        }
    }

    public static class Accounts {
        @SerializedName(value="authorized")
        private final int authorized;
        @SerializedName(value="authorized_to_maintain_liabilities")
        private final int authorizedToMaintainLiabilities;
        @SerializedName(value="unauthorized")
        private final int unauthorized;

        public Accounts(int authorized, int authorizedToMaintainLiabilities, int unauthorized) {
            this.authorized = authorized;
            this.authorizedToMaintainLiabilities = authorizedToMaintainLiabilities;
            this.unauthorized = unauthorized;
        }

        public int authorized() {
            return this.authorized;
        }

        public int authorizedToMaintainLiabilities() {
            return this.authorizedToMaintainLiabilities;
        }

        public int unauthorized() {
            return this.unauthorized;
        }
    }
}

