/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.IOException;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.TransactionResponse;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;

public class TransactionsRequestBuilder
extends RequestBuilder {
    public TransactionsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "transactions");
    }

    public TransactionResponse transaction(HttpUrl uri) throws IOException {
        TypeToken<TransactionResponse> type = new TypeToken<TransactionResponse>(){};
        ResponseHandler<TransactionResponse> responseHandler = new ResponseHandler<TransactionResponse>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = this.httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public TransactionResponse transaction(String transactionId) throws IOException {
        this.setSegments("transactions", transactionId);
        return this.transaction(this.buildUri());
    }

    public TransactionsRequestBuilder forAccount(String account) {
        account = Preconditions.checkNotNull(account, "account cannot be null");
        this.setSegments("accounts", account, "transactions");
        return this;
    }

    public TransactionsRequestBuilder forClaimableBalance(String claimableBalance) {
        claimableBalance = Preconditions.checkNotNull(claimableBalance, "claimableBalance cannot be null");
        this.setSegments("claimable_balances", claimableBalance, "transactions");
        return this;
    }

    public TransactionsRequestBuilder forLedger(long ledgerSeq) {
        this.setSegments("ledgers", String.valueOf(ledgerSeq), "transactions");
        return this;
    }

    public TransactionsRequestBuilder forLiquidityPool(LiquidityPoolID liquidityPoolID) {
        return this.forLiquidityPool(String.valueOf(liquidityPoolID));
    }

    public TransactionsRequestBuilder forLiquidityPool(String liquidityPoolID) {
        this.setSegments("liquidity_pools", liquidityPoolID, "transactions");
        return this;
    }

    public TransactionsRequestBuilder includeFailed(boolean value) {
        this.uriBuilder.setQueryParameter("include_failed", String.valueOf(value));
        return this;
    }

    public static Page<TransactionResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<TransactionResponse>> type = new TypeToken<Page<TransactionResponse>>(){};
        ResponseHandler<Page<TransactionResponse>> responseHandler = new ResponseHandler<Page<TransactionResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public SSEStream<TransactionResponse> stream(EventListener<TransactionResponse> listener) {
        return SSEStream.create(this.httpClient, this, TransactionResponse.class, listener);
    }

    public Page<TransactionResponse> execute() throws IOException, TooManyRequestsException {
        return TransactionsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public TransactionsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public TransactionsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public TransactionsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

