/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.Closeable;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.stellar.sdk.Util;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.responses.GsonSingleton;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import shadow.com.google.common.base.Optional;
import shadow.javax.annotation.Nullable;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.internal.sse.RealEventSource;
import shadow.okhttp3.sse.EventSource;
import shadow.okhttp3.sse.EventSourceListener;

public class SSEStream<T extends Response>
implements Closeable {
    private final OkHttpClient okHttpClient;
    private final RequestBuilder requestBuilder;
    private final Class<T> responseClass;
    private final EventListener<T> listener;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final AtomicBoolean serverSideClosed = new AtomicBoolean(true);
    private final AtomicReference<String> lastEventId = new AtomicReference<Object>(null);
    private ExecutorService executorService;
    private EventSource eventSource = null;
    private final Lock lock = new ReentrantLock();

    private SSEStream(OkHttpClient okHttpClient, RequestBuilder requestBuilder, Class<T> responseClass, EventListener<T> listener) {
        this.okHttpClient = okHttpClient.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.requestBuilder = requestBuilder;
        this.responseClass = responseClass;
        this.listener = listener;
        this.executorService = Executors.newSingleThreadExecutor();
        requestBuilder.buildUri();
    }

    private void start() {
        if (this.isStopped.get()) {
            throw new IllegalStateException("Already stopped");
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (!SSEStream.this.isStopped.get()) {
                    try {
                        Thread.sleep(200L);
                        if (!SSEStream.this.serverSideClosed.get()) continue;
                        SSEStream.this.serverSideClosed.set(false);
                        if (SSEStream.this.isStopped.get()) continue;
                        SSEStream.this.lock.lock();
                        try {
                            if (SSEStream.this.isStopped.get()) continue;
                            SSEStream.this.restart();
                        }
                        finally {
                            SSEStream.this.lock.unlock();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("interrupted", e);
                    }
                }
            }
        });
    }

    public String lastPagingToken() {
        return this.lastEventId.get();
    }

    private void restart() {
        this.eventSource = SSEStream.doStreamRequest(this, this.okHttpClient, this.requestBuilder, this.responseClass, this.listener, this.requestBuilder.uriBuilder.build().toString(), new CloseListener(){

            @Override
            public void closed(EventSource source) {
                SSEStream.this.serverSideClosed.set(true);
            }
        });
    }

    @Override
    public void close() {
        this.isStopped.set(true);
        if (this.eventSource != null) {
            this.eventSource.cancel();
        }
        this.executorService.shutdownNow();
    }

    static <T extends Response> SSEStream<T> create(OkHttpClient okHttpClient, RequestBuilder requestBuilder, Class<T> responseClass, EventListener<T> listener) {
        SSEStream<T> stream = new SSEStream<T>(okHttpClient, requestBuilder, responseClass, listener);
        super.start();
        return stream;
    }

    private static String addIdentificationQueryParameter(String url) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse(url).newBuilder().addQueryParameter("X-Client-Name", "java-stellar-sdk").addQueryParameter("X-Client-Version", Util.getSdkVersion());
        return urlBuilder.build().toString();
    }

    private static <T extends Response> EventSource doStreamRequest(SSEStream<T> stream, OkHttpClient okHttpClient, RequestBuilder requestBuilder, Class<T> responseClass, EventListener<T> listener, String url, CloseListener closeListener) {
        Request.Builder builder = new Request.Builder().url(SSEStream.addIdentificationQueryParameter(url)).header("Accept", "text/event-stream");
        String lastEventId = stream.lastEventId.get();
        if (lastEventId != null) {
            builder.header("Last-Event-ID", lastEventId);
        }
        Request request = builder.build();
        RealEventSource eventSource = new RealEventSource(request, new StellarEventSourceListener<T>(stream, closeListener, responseClass, requestBuilder, listener));
        eventSource.connect(okHttpClient);
        return eventSource;
    }

    private static class StellarEventSourceListener<T extends Response>
    extends EventSourceListener {
        private SSEStream<T> stream;
        private final CloseListener closeListener;
        private final Class<T> responseClass;
        private final RequestBuilder requestBuilder;
        private final EventListener<T> listener;

        StellarEventSourceListener(SSEStream<T> stream, CloseListener closeListener, Class<T> responseClass, RequestBuilder requestBuilder, EventListener<T> listener) {
            this.stream = stream;
            this.closeListener = closeListener;
            this.responseClass = responseClass;
            this.requestBuilder = requestBuilder;
            this.listener = listener;
        }

        @Override
        public void onClosed(EventSource eventSource) {
            if (this.closeListener != null) {
                this.closeListener.closed(eventSource);
            }
        }

        @Override
        public void onOpen(EventSource eventSource, shadow.okhttp3.Response response) {
        }

        @Override
        public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable shadow.okhttp3.Response response) {
            Optional<Integer> code = Optional.absent();
            if (response != null) {
                code = Optional.of(response.code());
            }
            if (t != null) {
                if (t instanceof SocketException) {
                    if (this.closeListener != null) {
                        this.closeListener.closed(eventSource);
                    }
                } else {
                    this.listener.onFailure(Optional.of(t), code);
                }
            } else {
                Optional<Throwable> absent = Optional.absent();
                this.listener.onFailure(absent, code);
            }
        }

        @Override
        public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
            if (data.equals("\"hello\"") || data.equals("\"byebye\"")) {
                return;
            }
            Response event = (Response)GsonSingleton.getInstance().fromJson(data, this.responseClass);
            if (event instanceof Pageable) {
                String pagingToken = ((Pageable)((Object)event)).getPagingToken();
                this.requestBuilder.cursor(pagingToken);
            }
            ((SSEStream)this.stream).lastEventId.set(id);
            this.listener.onEvent(event);
        }
    }

    private static interface CloseListener {
        public void closed(EventSource var1);
    }
}

