/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.IOException;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.OrderBookResponse;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;

public class OrderBookRequestBuilder
extends RequestBuilder {
    public OrderBookRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "order_book");
    }

    public OrderBookRequestBuilder buyingAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("buying_asset_type", asset.getType());
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("buying_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("buying_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public OrderBookRequestBuilder sellingAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("selling_asset_type", asset.getType());
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("selling_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("selling_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public static OrderBookResponse execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<OrderBookResponse> type = new TypeToken<OrderBookResponse>(){};
        ResponseHandler<OrderBookResponse> responseHandler = new ResponseHandler<OrderBookResponse>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public SSEStream<OrderBookResponse> stream(EventListener<OrderBookResponse> listener) {
        return SSEStream.create(this.httpClient, this, OrderBookResponse.class, listener);
    }

    public OrderBookResponse execute() throws IOException, TooManyRequestsException {
        return OrderBookRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public RequestBuilder cursor(String cursor) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public RequestBuilder order(RequestBuilder.Order direction) {
        throw new RuntimeException("Not implemented yet.");
    }
}

