/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.IOException;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.effects.EffectResponse;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;

public class EffectsRequestBuilder
extends RequestBuilder {
    public EffectsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "effects");
    }

    public EffectsRequestBuilder forAccount(String account) {
        account = Preconditions.checkNotNull(account, "account cannot be null");
        this.setSegments("accounts", account, "effects");
        return this;
    }

    public EffectsRequestBuilder forLedger(long ledgerSeq) {
        this.setSegments("ledgers", String.valueOf(ledgerSeq), "effects");
        return this;
    }

    public EffectsRequestBuilder forTransaction(String transactionId) {
        transactionId = Preconditions.checkNotNull(transactionId, "transactionId cannot be null");
        this.setSegments("transactions", transactionId, "effects");
        return this;
    }

    public EffectsRequestBuilder forLiquidityPool(LiquidityPoolID liquidityPoolID) {
        return this.forLiquidityPool(String.valueOf(liquidityPoolID));
    }

    public EffectsRequestBuilder forLiquidityPool(String liquidityPoolID) {
        this.setSegments("liquidity_pools", liquidityPoolID, "effects");
        return this;
    }

    public EffectsRequestBuilder forOperation(long operationId) {
        this.setSegments("operations", String.valueOf(operationId), "effects");
        return this;
    }

    public static Page<EffectResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<EffectResponse>> type = new TypeToken<Page<EffectResponse>>(){};
        ResponseHandler<Page<EffectResponse>> responseHandler = new ResponseHandler<Page<EffectResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public SSEStream<EffectResponse> stream(EventListener<EffectResponse> listener) {
        return SSEStream.create(this.httpClient, this, EffectResponse.class, listener);
    }

    public Page<EffectResponse> execute() throws IOException, TooManyRequestsException {
        return EffectsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public EffectsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public EffectsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public EffectsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

