/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import java.io.IOException;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.AssetResponse;
import org.stellar.sdk.responses.Page;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;

public class AssetsRequestBuilder
extends RequestBuilder {
    public AssetsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "assets");
    }

    public AssetsRequestBuilder assetCode(String assetCode) {
        this.uriBuilder.setQueryParameter("asset_code", assetCode);
        return this;
    }

    public AssetsRequestBuilder assetIssuer(String assetIssuer) {
        this.uriBuilder.setQueryParameter("asset_issuer", assetIssuer);
        return this;
    }

    public static Page<AssetResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<AssetResponse>> type = new TypeToken<Page<AssetResponse>>(){};
        ResponseHandler<Page<AssetResponse>> responseHandler = new ResponseHandler<Page<AssetResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public Page<AssetResponse> execute() throws IOException, TooManyRequestsException {
        return AssetsRequestBuilder.execute(this.httpClient, this.buildUri());
    }
}

