/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.federation;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.stellar.sdk.federation.ConnectionErrorException;
import org.stellar.sdk.federation.FederationResponse;
import org.stellar.sdk.federation.FederationServerInvalidException;
import org.stellar.sdk.federation.MalformedAddressException;
import org.stellar.sdk.federation.NoFederationServerException;
import org.stellar.sdk.federation.NotFoundException;
import org.stellar.sdk.federation.StellarTomlNotFoundInvalidException;
import org.stellar.sdk.requests.ResponseHandler;
import shadow.com.google.gson.reflect.TypeToken;
import shadow.com.moandjiezana.toml.Toml;
import shadow.okhttp3.HttpUrl;
import shadow.okhttp3.OkHttpClient;
import shadow.okhttp3.Request;
import shadow.okhttp3.Response;

public class FederationServer {
    private final HttpUrl serverUri;
    private final String domain;
    private final OkHttpClient httpClient;
    static boolean httpsConnection = true;

    public FederationServer(URI serverUri, String domain) {
        block3: {
            block2: {
                this.serverUri = HttpUrl.get(serverUri);
                if (this.serverUri == null) break block2;
                if (this.serverUri == null) break block3;
                if (!httpsConnection || this.serverUri.isHttps()) break block3;
            }
            throw new FederationServerInvalidException();
        }
        this.domain = domain;
        this.httpClient = FederationServer.createHttpClient();
    }

    private static OkHttpClient createHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(false).build();
    }

    public FederationServer(String serverUri, String domain) {
        this(HttpUrl.parse(serverUri).uri(), domain);
    }

    public static FederationServer createForDomain(String domain) {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append(httpsConnection ? "https://" : "http://");
        uriBuilder.append(domain);
        uriBuilder.append("/.well-known/stellar.toml");
        HttpUrl stellarTomlUri = HttpUrl.parse(uriBuilder.toString());
        OkHttpClient httpClient = FederationServer.createHttpClient();
        Request request = new Request.Builder().get().url(stellarTomlUri).build();
        Response response = null;
        try {
            response = httpClient.newCall(request).execute();
            if (response.code() >= 300) {
                throw new StellarTomlNotFoundInvalidException();
            }
            Toml stellarToml = new Toml().read(response.body().string());
            String federationServer = stellarToml.getString("FEDERATION_SERVER");
            if (federationServer == null) {
                throw new NoFederationServerException();
            }
            FederationServer federationServer2 = new FederationServer(federationServer, domain);
            return federationServer2;
        }
        catch (IOException e) {
            throw new ConnectionErrorException();
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public FederationResponse resolveAddress(String address) {
        String[] tokens = address.split("\\*");
        if (tokens.length != 2) {
            throw new MalformedAddressException();
        }
        HttpUrl.Builder uriBuilder = this.serverUri.newBuilder();
        uriBuilder.setQueryParameter("type", "name");
        uriBuilder.setQueryParameter("q", address);
        HttpUrl uri = uriBuilder.build();
        TypeToken<FederationResponse> type = new TypeToken<FederationResponse>(){};
        ResponseHandler<FederationResponse> responseHandler = new ResponseHandler<FederationResponse>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = null;
        try {
            response = this.httpClient.newCall(request).execute();
            if (response.code() == 404) {
                throw new NotFoundException();
            }
            FederationResponse federationResponse = responseHandler.handleResponse(response);
            return federationResponse;
        }
        catch (IOException e) {
            throw new ConnectionErrorException();
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public HttpUrl getServerUri() {
        return this.serverUri;
    }

    public String getDomain() {
        return this.domain;
    }
}

