/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.Uint64;
import shadow.com.google.common.base.Objects;

public final class TimeBounds {
    private final long mMinTime;
    private final long mMaxTime;

    public TimeBounds(long minTime, long maxTime) {
        if (minTime < 0L) {
            throw new IllegalArgumentException("minTime cannot be negative");
        }
        if (maxTime < 0L) {
            throw new IllegalArgumentException("maxTime cannot be negative");
        }
        if (maxTime != 0L && minTime > maxTime) {
            throw new IllegalArgumentException("minTime must be >= maxTime");
        }
        this.mMinTime = minTime;
        this.mMaxTime = maxTime;
    }

    public static TimeBounds expiresAfter(long timeout) {
        long now = System.currentTimeMillis() / 1000L;
        long endTime = now + timeout;
        return new TimeBounds(0L, endTime);
    }

    public long getMinTime() {
        return this.mMinTime;
    }

    public long getMaxTime() {
        return this.mMaxTime;
    }

    public static TimeBounds fromXdr(org.stellar.sdk.xdr.TimeBounds timeBounds) {
        if (timeBounds == null) {
            return null;
        }
        return new TimeBounds(timeBounds.getMinTime().getTimePoint().getUint64(), timeBounds.getMaxTime().getTimePoint().getUint64());
    }

    public org.stellar.sdk.xdr.TimeBounds toXdr() {
        org.stellar.sdk.xdr.TimeBounds timeBounds = new org.stellar.sdk.xdr.TimeBounds();
        TimePoint minTime = new TimePoint();
        TimePoint maxTime = new TimePoint();
        Uint64 minTimeTemp = new Uint64();
        Uint64 maxTimeTemp = new Uint64();
        minTimeTemp.setUint64(this.mMinTime);
        maxTimeTemp.setUint64(this.mMaxTime);
        minTime.setTimePoint(minTimeTemp);
        maxTime.setTimePoint(maxTimeTemp);
        timeBounds.setMinTime(minTime);
        timeBounds.setMaxTime(maxTime);
        return timeBounds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeBounds that = (TimeBounds)o;
        return this.mMinTime == that.mMinTime && this.mMaxTime == that.mMaxTime;
    }

    public int hashCode() {
        return Objects.hashCode(this.mMaxTime, this.mMinTime);
    }
}

