/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PaymentOp;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class PaymentOperation
extends Operation {
    private final String destination;
    private final Asset asset;
    private final String amount;

    private PaymentOperation(String destination, Asset asset, String amount) {
        this.destination = Preconditions.checkNotNull(destination, "destination cannot be null");
        this.asset = Preconditions.checkNotNull(asset, "asset cannot be null");
        this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
    }

    public String getDestination() {
        return this.destination;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public String getAmount() {
        return this.amount;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        PaymentOp op = new PaymentOp();
        op.setDestination(accountConverter.encode(this.destination));
        op.setAsset(this.asset.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PAYMENT);
        body.setPaymentOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.asset, this.amount, this.destination);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PaymentOperation)) {
            return false;
        }
        PaymentOperation other = (PaymentOperation)object;
        return Objects.equal(this.getSourceAccount(), other.getSourceAccount()) && Objects.equal(this.asset, other.asset) && Objects.equal(this.amount, other.amount) && Objects.equal(this.destination, other.destination);
    }

    public static class Builder {
        private final String destination;
        private final Asset asset;
        private final String amount;
        private String mSourceAccount;

        Builder(AccountConverter accountConverter, PaymentOp op) {
            this.destination = accountConverter.decode(op.getDestination());
            this.asset = Asset.fromXdr(op.getAsset());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        }

        public Builder(String destination, Asset asset, String amount) {
            this.destination = destination;
            this.asset = asset;
            this.amount = amount;
        }

        public Builder setSourceAccount(String account) {
            this.mSourceAccount = account;
            return this;
        }

        public PaymentOperation build() {
            PaymentOperation operation = new PaymentOperation(this.destination, this.asset, this.amount);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

