/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.nio.charset.Charset;
import org.stellar.sdk.Util;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class Network {
    public static final Network PUBLIC = new Network("Public Global Stellar Network ; September 2015");
    public static final Network TESTNET = new Network("Test SDF Network ; September 2015");
    private final String networkPassphrase;

    public Network(String networkPassphrase) {
        this.networkPassphrase = Preconditions.checkNotNull(networkPassphrase, "networkPassphrase cannot be null");
    }

    public String getNetworkPassphrase() {
        return this.networkPassphrase;
    }

    public byte[] getNetworkId() {
        return Util.hash(this.networkPassphrase.getBytes(Charset.forName("UTF-8")));
    }

    public int hashCode() {
        return this.networkPassphrase.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Network)) {
            return false;
        }
        Network other = (Network)object;
        return Objects.equal(this.networkPassphrase, other.networkPassphrase);
    }

    public String toString() {
        return this.networkPassphrase;
    }
}

