/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.MemoHash;
import org.stellar.sdk.MemoId;
import org.stellar.sdk.MemoNone;
import org.stellar.sdk.MemoReturnHash;
import org.stellar.sdk.MemoText;
import shadow.com.google.common.io.BaseEncoding;

public abstract class Memo {
    public static MemoNone none() {
        return new MemoNone();
    }

    public static MemoText text(String text) {
        return new MemoText(text);
    }

    public static MemoText text(byte[] text) {
        return new MemoText(text);
    }

    public static MemoId id(long id) {
        return new MemoId(id);
    }

    public static MemoHash hash(byte[] bytes) {
        return new MemoHash(bytes);
    }

    public static MemoHash hash(String hexString) {
        return new MemoHash(hexString);
    }

    public static MemoReturnHash returnHash(byte[] bytes) {
        return new MemoReturnHash(bytes);
    }

    public static MemoReturnHash returnHash(String hexString) {
        return new MemoReturnHash(BaseEncoding.base16().lowerCase().decode(hexString.toLowerCase()));
    }

    public static Memo fromXdr(org.stellar.sdk.xdr.Memo memo) {
        switch (memo.getDiscriminant()) {
            case MEMO_NONE: {
                return Memo.none();
            }
            case MEMO_ID: {
                return Memo.id(memo.getId().getUint64());
            }
            case MEMO_TEXT: {
                return Memo.text(memo.getText().getBytes());
            }
            case MEMO_HASH: {
                return Memo.hash(memo.getHash().getHash());
            }
            case MEMO_RETURN: {
                return Memo.returnHash(memo.getRetHash().getHash());
            }
        }
        throw new RuntimeException("Unknown memo type");
    }

    abstract org.stellar.sdk.xdr.Memo toXdr();

    public abstract boolean equals(Object var1);
}

