/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Price;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.ManageSellOfferOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class ManageSellOfferOperation
extends Operation {
    private final Asset selling;
    private final Asset buying;
    private final String amount;
    private final String price;
    private final long offerId;

    private ManageSellOfferOperation(Asset selling, Asset buying, String amount, String price, long offerId) {
        this.selling = Preconditions.checkNotNull(selling, "selling cannot be null");
        this.buying = Preconditions.checkNotNull(buying, "buying cannot be null");
        this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
        this.price = Preconditions.checkNotNull(price, "price cannot be null");
        this.offerId = offerId;
    }

    public Asset getSelling() {
        return this.selling;
    }

    public Asset getBuying() {
        return this.buying;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getPrice() {
        return this.price;
    }

    public long getOfferId() {
        return this.offerId;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ManageSellOfferOp op = new ManageSellOfferOp();
        op.setSelling(this.selling.toXdr());
        op.setBuying(this.buying.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        Price price = Price.fromString(this.price);
        op.setPrice(price.toXdr());
        Int64 offerId = new Int64();
        offerId.setInt64(this.offerId);
        op.setOfferID(offerId);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.MANAGE_SELL_OFFER);
        body.setManageSellOfferOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.amount, this.buying, this.offerId, this.price, this.selling);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManageSellOfferOperation)) {
            return false;
        }
        ManageSellOfferOperation other = (ManageSellOfferOperation)object;
        return Objects.equal(this.getSourceAccount(), other.getSourceAccount()) && Objects.equal(this.amount, other.amount) && Objects.equal(this.buying, other.buying) && Objects.equal(this.offerId, other.offerId) && Objects.equal(this.price, other.price) && Objects.equal(this.selling, other.selling);
    }

    public static class Builder {
        private final Asset selling;
        private final Asset buying;
        private final String amount;
        private final String price;
        private long offerId = 0L;
        private String mSourceAccount;

        Builder(ManageSellOfferOp op) {
            this.selling = Asset.fromXdr(op.getSelling());
            this.buying = Asset.fromXdr(op.getBuying());
            this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
            this.price = Price.fromXdr(op.getPrice()).toString();
            this.offerId = op.getOfferID().getInt64();
        }

        public Builder(Asset selling, Asset buying, String amount, String price) {
            this.selling = Preconditions.checkNotNull(selling, "selling cannot be null");
            this.buying = Preconditions.checkNotNull(buying, "buying cannot be null");
            this.amount = Preconditions.checkNotNull(amount, "amount cannot be null");
            this.price = Preconditions.checkNotNull(price, "price cannot be null");
        }

        public Builder setOfferId(long offerId) {
            this.offerId = offerId;
            return this;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public ManageSellOfferOperation build() {
            ManageSellOfferOperation operation = new ManageSellOfferOperation(this.selling, this.buying, this.amount, this.price, this.offerId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

