/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.TrustLineAsset;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public final class LiquidityPoolShareTrustLineAsset
extends org.stellar.sdk.TrustLineAsset {
    protected final LiquidityPoolID mId;

    public LiquidityPoolShareTrustLineAsset(LiquidityPoolParameters params) {
        Preconditions.checkNotNull(params, "params cannot be null");
        this.mId = params.getId();
    }

    public LiquidityPoolShareTrustLineAsset(LiquidityPoolID id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        this.mId = id;
    }

    public LiquidityPoolID getLiquidityPoolID() {
        return this.mId;
    }

    @Override
    public String getType() {
        return "pool_share";
    }

    public String toString() {
        return this.getLiquidityPoolID().toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.mId);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LiquidityPoolShareTrustLineAsset o = (LiquidityPoolShareTrustLineAsset)object;
        return this.toString() == o.toString();
    }

    @Override
    public int compareTo(org.stellar.sdk.TrustLineAsset other) {
        if (other.getType() != "pool_share") {
            return 1;
        }
        return this.toString().compareTo(((LiquidityPoolShareTrustLineAsset)other).toString());
    }

    @Override
    public TrustLineAsset toXdr() {
        TrustLineAsset xdr = new TrustLineAsset();
        xdr.setDiscriminant(AssetType.ASSET_TYPE_POOL_SHARE);
        xdr.setLiquidityPoolID(this.mId.toXdr());
        return xdr;
    }
}

