/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Asset;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import shadow.com.google.common.base.Objects;

public final class LiquidityPoolID {
    protected final byte[] hash;

    public LiquidityPoolID(LiquidityPoolType type, Asset a, Asset b, int fee) {
        if (a.compareTo(b) >= 0) {
            throw new RuntimeException("AssetA must be < AssetB");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        try {
            LiquidityPoolParameters.create(type, a, b, fee).toXdr().encode(xdrDataOutputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid liquidity pool id.", e);
        }
        this.hash = Util.hash(byteArrayOutputStream.toByteArray());
    }

    public LiquidityPoolID(String hex) {
        this.hash = Util.hexToBytes(hex.toUpperCase());
    }

    public LiquidityPoolID(byte[] bytes) {
        this.hash = bytes;
    }

    public static LiquidityPoolID fromXdr(PoolID xdr) {
        return new LiquidityPoolID(xdr.getPoolID().getHash());
    }

    public String toString() {
        return Util.bytesToHex(this.hash).toLowerCase();
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LiquidityPoolID o = (LiquidityPoolID)object;
        return Objects.equal(this.toString(), o.toString());
    }

    public PoolID toXdr() {
        PoolID xdr = new PoolID();
        xdr.setPoolID(new Hash(this.hash));
        return xdr;
    }
}

