/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.Asset;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.xdr.Int32;
import org.stellar.sdk.xdr.LiquidityPoolParameters;
import org.stellar.sdk.xdr.LiquidityPoolType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public final class LiquidityPoolConstantProductParameters
extends org.stellar.sdk.LiquidityPoolParameters {
    protected final Asset assetA;
    protected final Asset assetB;
    protected final int fee;

    public LiquidityPoolConstantProductParameters(Asset a, Asset b, int feeBP) {
        Preconditions.checkNotNull(a, "asset A cannot be null");
        Preconditions.checkNotNull(b, "asset B cannot be null");
        Preconditions.checkNotNull(feeBP, "fee cannot be null");
        this.assetA = a;
        this.assetB = b;
        this.fee = feeBP;
    }

    public Asset getAssetA() {
        return this.assetA;
    }

    public Asset getAssetB() {
        return this.assetB;
    }

    public int getFee() {
        return this.fee;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LiquidityPoolConstantProductParameters o = (LiquidityPoolConstantProductParameters)object;
        return Objects.equal(this.getAssetA(), o.getAssetA()) && Objects.equal(this.getAssetB(), o.getAssetB()) && Objects.equal(this.getFee(), o.getFee());
    }

    @Override
    public final LiquidityPoolParameters toXdr() {
        LiquidityPoolParameters xdr = new LiquidityPoolParameters();
        xdr.setDiscriminant(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT);
        org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters params = new org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters();
        params.setAssetA(this.assetA.toXdr());
        params.setAssetB(this.assetB.toXdr());
        params.setFee(new Int32(this.fee));
        xdr.setConstantProduct(params);
        return xdr;
    }

    public static LiquidityPoolConstantProductParameters fromXdr(org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters xdr) {
        return new LiquidityPoolConstantProductParameters(Asset.fromXdr(xdr.getAssetA()), Asset.fromXdr(xdr.getAssetB()), xdr.getFee().getInt32());
    }

    @Override
    public final LiquidityPoolID getId() {
        return new LiquidityPoolID(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT, this.assetA, this.assetB, this.fee);
    }
}

