/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.Arrays;
import org.stellar.sdk.SLIP10;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.PublicKey;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.SignerKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;
import shadow.net.i2p.crypto.eddsa.EdDSAEngine;
import shadow.net.i2p.crypto.eddsa.EdDSAPrivateKey;
import shadow.net.i2p.crypto.eddsa.EdDSAPublicKey;
import shadow.net.i2p.crypto.eddsa.KeyPairGenerator;
import shadow.net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import shadow.net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import shadow.net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import shadow.net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import shadow.net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class KeyPair {
    private static final EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.ED_25519_CURVE_SPEC;
    private final EdDSAPublicKey mPublicKey;
    private final EdDSAPrivateKey mPrivateKey;

    public KeyPair(EdDSAPublicKey publicKey) {
        this(publicKey, null);
    }

    public KeyPair(EdDSAPublicKey publicKey, EdDSAPrivateKey privateKey) {
        this.mPublicKey = Preconditions.checkNotNull(publicKey, "publicKey cannot be null");
        this.mPrivateKey = privateKey;
    }

    public boolean canSign() {
        return this.mPrivateKey != null;
    }

    public static KeyPair fromSecretSeed(char[] seed) {
        byte[] decoded = StrKey.decodeStellarSecretSeed(seed);
        KeyPair keypair = KeyPair.fromSecretSeed(decoded);
        Arrays.fill(decoded, (byte)0);
        return keypair;
    }

    public static KeyPair fromSecretSeed(String seed) {
        char[] charSeed = seed.toCharArray();
        byte[] decoded = StrKey.decodeStellarSecretSeed(charSeed);
        KeyPair keypair = KeyPair.fromSecretSeed(decoded);
        Arrays.fill(charSeed, ' ');
        return keypair;
    }

    public static KeyPair fromSecretSeed(byte[] seed) {
        EdDSAPrivateKeySpec privKeySpec = new EdDSAPrivateKeySpec(seed, ed25519);
        EdDSAPublicKeySpec publicKeySpec = new EdDSAPublicKeySpec(privKeySpec.getA().toByteArray(), (EdDSAParameterSpec)ed25519);
        return new KeyPair(new EdDSAPublicKey(publicKeySpec), new EdDSAPrivateKey(privKeySpec));
    }

    public static KeyPair fromAccountId(String accountId) {
        byte[] decoded = StrKey.decodeStellarAccountId(accountId);
        return KeyPair.fromPublicKey(decoded);
    }

    public static KeyPair fromPublicKey(byte[] publicKey) {
        EdDSAPublicKeySpec publicKeySpec;
        try {
            publicKeySpec = new EdDSAPublicKeySpec(publicKey, (EdDSAParameterSpec)ed25519);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Public key is invalid");
        }
        return new KeyPair(new EdDSAPublicKey(publicKeySpec));
    }

    public static KeyPair fromBip39Seed(byte[] bip39Seed, int accountNumber) {
        try {
            return KeyPair.fromSecretSeed(SLIP10.deriveEd25519PrivateKey(bip39Seed, 44, 148, accountNumber));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair random() {
        java.security.KeyPair keypair = new KeyPairGenerator().generateKeyPair();
        return new KeyPair((EdDSAPublicKey)keypair.getPublic(), (EdDSAPrivateKey)keypair.getPrivate());
    }

    public String getAccountId() {
        return StrKey.encodeStellarAccountId(this.mPublicKey.getAbyte());
    }

    public char[] getSecretSeed() {
        return StrKey.encodeStellarSecretSeed(this.mPrivateKey.getSeed());
    }

    public byte[] getPublicKey() {
        return this.mPublicKey.getAbyte();
    }

    public SignatureHint getSignatureHint() {
        try {
            ByteArrayOutputStream publicKeyBytesStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrOutputStream = new XdrDataOutputStream(publicKeyBytesStream);
            PublicKey.encode(xdrOutputStream, this.getXdrPublicKey());
            byte[] publicKeyBytes = publicKeyBytesStream.toByteArray();
            byte[] signatureHintBytes = Arrays.copyOfRange(publicKeyBytes, publicKeyBytes.length - 4, publicKeyBytes.length);
            SignatureHint signatureHint = new SignatureHint();
            signatureHint.setSignatureHint(signatureHintBytes);
            return signatureHint;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public PublicKey getXdrPublicKey() {
        PublicKey publicKey = new PublicKey();
        publicKey.setDiscriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519);
        Uint256 uint256 = new Uint256();
        uint256.setUint256(this.getPublicKey());
        publicKey.setEd25519(uint256);
        return publicKey;
    }

    public SignerKey getXdrSignerKey() {
        SignerKey signerKey = new SignerKey();
        signerKey.setDiscriminant(SignerKeyType.SIGNER_KEY_TYPE_ED25519);
        Uint256 uint256 = new Uint256();
        uint256.setUint256(this.getPublicKey());
        signerKey.setEd25519(uint256);
        return signerKey;
    }

    public static KeyPair fromXdrPublicKey(PublicKey key) {
        return KeyPair.fromPublicKey(key.getEd25519().getUint256());
    }

    public static KeyPair fromXdrSignerKey(SignerKey key) {
        return KeyPair.fromPublicKey(key.getEd25519().getUint256());
    }

    public byte[] sign(byte[] data) {
        if (this.mPrivateKey == null) {
            throw new RuntimeException("KeyPair does not contain secret key. Use KeyPair.fromSecretSeed method to create a new KeyPair with a secret key.");
        }
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            sgr.initSign(this.mPrivateKey);
            sgr.update(data);
            return sgr.sign();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public DecoratedSignature signDecorated(byte[] data) {
        byte[] signatureBytes = this.sign(data);
        Signature signature = new Signature();
        signature.setSignature(signatureBytes);
        DecoratedSignature decoratedSignature = new DecoratedSignature();
        decoratedSignature.setHint(this.getSignatureHint());
        decoratedSignature.setSignature(signature);
        return decoratedSignature;
    }

    public boolean verify(byte[] data, byte[] signature) {
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            sgr.initVerify(this.mPublicKey);
            sgr.update(data);
            return sgr.verify(signature);
        }
        catch (SignatureException e) {
            return false;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.mPrivateKey, this.mPublicKey);
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair)object;
        return this.mPrivateKey.equals(other.mPrivateKey) && this.mPublicKey.equals(other.mPublicKey);
    }
}

